/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

public class TestDictionaryStructure
extends CcsTestCaseTemplate {
    @Test
    public void testDictionaryStructure() throws Exception {
        Subsystem s = BootUtils.getSubsystemFromFile((String)"simpleModuleWithDeepStructure");
        String sName = s.getName();
        s.startAgent();
        ((AgentStateService)s.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        Subsystem busMaster = new Subsystem("console", AgentInfo.AgentType.CONSOLE);
        busMaster.startAgent();
        ((AgentStateService)busMaster.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        ConsoleCommandShell comShell = new ConsoleCommandShell((Agent)busMaster);
        Thread.sleep(100L);
        Set routesSet = comShell.getConsoleCommandSet().getRoutes().keySet();
        Assert.assertEquals((String)routesSet.toString(), (long)14L, (long)routesSet.size());
        Assert.assertTrue((boolean)routesSet.contains(sName));
        Assert.assertTrue((boolean)routesSet.contains(sName + "/childModule"));
        Assert.assertTrue((boolean)routesSet.contains(sName + "/c1"));
        Assert.assertTrue((boolean)routesSet.contains(sName + "/c2"));
        Assert.assertFalse((boolean)routesSet.contains(sName + "/childConfigurable"));
        Assert.assertTrue((boolean)routesSet.contains(sName + "/agentStatusAggregatorService"));
        comShell.getConsoleCommandSet().invoke((BasicCommand)new TokenizedCommand("set target " + sName));
        comShell.getConsoleCommandSet().getCommandDictionary().setLevelForTypes(3, new Command.CommandType[0]);
        Object obj = comShell.getConsoleCommandSet().invoke((BasicCommand)new TokenizedCommand("set target " + sName + "/c1"));
        s.shutdownAgent();
        busMaster.shutdownAgent();
    }
}

