/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.DummyLock;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentLockService
implements LockLevelService,
AgentPresenceListener,
ServiceLifecycle,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.lockservice");
    private final List<AgentLevelListener> agentLevelListeners = new CopyOnWriteArrayList<AgentLevelListener>();
    private final List<AgentLockUpdateListener> agentLockUpdateListeners = new CopyOnWriteArrayList<AgentLockUpdateListener>();
    private final Map<String, Integer> agentLevels = new HashMap<String, Integer>();
    private final Map<String, AgentLock> heldLocks = new HashMap<String, AgentLock>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;

    @Override
    public String getAgentServiceName() {
        return "lockService";
    }

    @Override
    public void preInit() {
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        AgentLock lock = this.heldLocks.get(agentName);
        if (lock == null) {
            this.lockAgent(agentName);
        }
        this.setLevelInternal(agentName, level);
    }

    public synchronized int getLevelForAgent(String agentName) {
        if (this.heldLocks.get(agentName) == null) {
            return 0;
        }
        return this.agentLevels.get(agentName);
    }

    public AgentLock getLockForAgent(String agentName) {
        return this.getHeldLocks().get(agentName);
    }

    public void lockAgent(String agentName) throws UnauthorizedLockException, IOException {
        if (this.heldLocks.get(agentName) != null) {
            return;
        }
        log.fine((Object)("acquiring lock for " + agentName));
        DummyLock lock = new DummyLock(agentName, this.agent.getName());
        this.setLockInternal(agentName, (AgentLock)lock);
        log.fine((Object)(this.agent.getName() + " acquired a lock for agent " + agentName));
    }

    public void unlockAgent(String agentName) throws IOException {
        try {
            this.setLevelInternal(agentName, 0);
            this.setLockInternal(agentName, null);
        }
        catch (UnauthorizedLevelException | UnauthorizedLockException ex) {
            log.warning((Object)"Something went really wrong as we should not get these exceptions when unlocking.", (Throwable)ex);
        }
        log.fine((Object)(this.agent.getName() + " released a lock for agent " + agentName));
    }

    public Map<String, AgentLock> getLocks() {
        return Collections.EMPTY_MAP;
    }

    public Map<String, AgentLock> getHeldLocks() {
        return Collections.unmodifiableMap(this.heldLocks);
    }

    public boolean validateLock(AgentLock lock) {
        return true;
    }

    public void addAgentLevelListener(AgentLevelListener l) {
        for (Map.Entry<String, Integer> entry : this.agentLevels.entrySet()) {
            l.onAgentLevelChange(entry.getKey(), entry.getValue());
        }
        this.agentLevelListeners.add(l);
    }

    public void removeAgentLevelListener(AgentLevelListener l) {
        this.agentLevelListeners.remove(l);
    }

    public void addAgentLockUpdateListener(AgentLockUpdateListener slul) {
        for (Map.Entry<String, AgentLock> entry : this.heldLocks.entrySet()) {
            slul.onAgentLockUpdate(entry.getKey(), entry.getValue());
        }
        this.agentLockUpdateListeners.add(slul);
    }

    public void removeAgentLockUpdateListener(AgentLockUpdateListener l) {
        this.agentLockUpdateListeners.remove(l);
    }

    private void setLockInternal(String agentName, AgentLock lock) throws UnauthorizedLockException, IOException {
        this.heldLocks.put(agentName, lock);
        this.agentLockUpdateListeners.forEach(l -> l.onAgentLockUpdate(agentName, lock));
    }

    private void setLevelInternal(String agentName, int level) throws UnauthorizedLevelException, IOException {
        log.fine((Object)(this.agent.getName() + " set a level for agent " + agentName + " to " + level));
        this.agentLevels.put(agentName, level);
        this.agentLevelListeners.forEach(l -> l.onAgentLevelChange(agentName, level));
    }

    public synchronized void connecting(AgentInfo ai) {
        int initialLevel;
        if (ai.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) != 0) {
            return;
        }
        String name = ai.getName();
        AgentLock initialLock = null;
        if (!this.heldLocks.containsKey(name)) {
            initialLock = null;
            initialLevel = 0;
        } else {
            initialLock = this.heldLocks.get(name);
            Integer desiredLevel = this.agentLevels.get(name);
            initialLevel = desiredLevel == null ? initialLock.getMaxLevel() : desiredLevel.intValue();
        }
        try {
            this.setLevelInternal(name, initialLevel);
            this.setLockInternal(name, initialLock);
        }
        catch (IOException | UnauthorizedLevelException | UnauthorizedLockException ex) {
            log.warning((Object)"Problems trying to re-lock a connecting subsystem.", (Throwable)ex);
        }
    }

    public List<String> getLockableAgents() {
        ArrayList<String> result = new ArrayList<String>();
        for (AgentInfo a : this.agent.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
            if (!a.getType().equals((Object)AgentInfo.AgentType.WORKER) || this.heldLocks.get(a.getName()) != null) continue;
            result.add(a.getName());
        }
        return result;
    }

    public List<String> getLockedAgents() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, AgentLock> e : this.heldLocks.entrySet()) {
            if (e.getValue() == null) continue;
            res.add(e.getKey());
        }
        return res;
    }

    public List<String> getAllWorkerAgents() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getLockableAgents());
        result.addAll(this.getLockedAgents());
        return result;
    }

    public static interface AgentLockUpdateListener {
        public void onAgentLockUpdate(String var1, AgentLock var2);
    }

    public static interface AgentLevelListener {
        public void onAgentLevelChange(String var1, int var2);
    }
}

