/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

final class JythonConsoleResult
implements Callable<String> {
    private final BufferedReader reader;
    private final StringBuffer buffer = new StringBuffer();
    private final String contentId;
    private final FutureTask<String> future;
    private final PrintStream out;

    JythonConsoleResult(BufferedReader reader, String contentId, PrintStream out) {
        this.reader = reader;
        this.contentId = contentId;
        this.future = new FutureTask<String>(this);
        this.out = out;
    }

    @Override
    public String call() throws Exception {
        try {
            String line;
            while ((line = this.reader.readLine()) != null && !line.contains("doneExecution:" + this.contentId)) {
                this.buffer.append(line + "\n");
                if (this.out == null) continue;
                this.out.println(line);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return this.buffer.toString();
    }

    String getResult() {
        try {
            return this.future.get();
        }
        catch (InterruptedException | ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    FutureTask<String> getFuture() {
        return this.future;
    }
}

