/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

@RunWith(value=Parameterized.class)
public class ManySubsystemsTest
extends CcsTestCaseTemplate {
    @Parameterized.Parameters(name="{0}")
    public static List<String> getTransportProtocols() {
        return Arrays.asList("jgroups:udp_ccs:", "mock:single:");
    }

    public ManySubsystemsTest(String transport) {
        super(transport);
    }

    @Test
    public void testConsoleDictionaryFetching() throws Exception {
        Agent a;
        int i;
        int agentCount = 10;
        ArrayList<Agent> agents = new ArrayList<Agent>();
        for (int i2 = 0; i2 < agentCount; ++i2) {
            AgentInfo.AgentType type = AgentInfo.AgentType.WORKER;
            Agent a2 = new Agent("agent-" + i2 + "-" + type.name(), type);
            a2.startAgent();
            agents.add(a2);
            Thread.sleep(200L);
        }
        BusMaster busMaster = new BusMaster("console");
        busMaster.startAgent();
        ConsoleCommandShell comShell = new ConsoleCommandShell((Agent)busMaster);
        comShell.init();
        final JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shell.run();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        });
        t.start();
        Thread.sleep(1000L);
        for (i = 0; i < agentCount; ++i) {
            a = (Agent)agents.get(i);
            Assert.assertTrue((boolean)comShell.getConsoleCommandSet().containsPath(a.getName()));
        }
        for (i = 0; i < agentCount; ++i) {
            a = (Agent)agents.get(i);
            a.shutdownAgent();
            Thread.sleep(200L);
        }
        Thread.sleep(1000L);
        for (i = 0; i < agentCount; ++i) {
            a = (Agent)agents.get(i);
            Assert.assertTrue((boolean)comShell.getConsoleCommandSet().getCommandSetsForRoute(a.getName()).isEmpty());
        }
        t.interrupt();
        busMaster.shutdownAgent();
        Thread.sleep(200L);
    }

    @Test
    public void testListSubsystems() throws Exception {
        Agent a;
        int i;
        AgentInfo.AgentType[] availableTypes = AgentInfo.AgentType.values();
        int agentCount = availableTypes.length * 2;
        ArrayList<Agent> agents = new ArrayList<Agent>();
        for (int i2 = 0; i2 < agentCount; ++i2) {
            AgentInfo.AgentType type = availableTypes[i2 % availableTypes.length];
            Agent a2 = new Agent("agent-" + i2 + "-" + type.name(), type);
            a2.startAgent();
            agents.add(a2);
            Thread.sleep(200L);
        }
        BusMaster busMaster = new BusMaster("console");
        busMaster.startAgent();
        ConsoleCommandShell comShell = new ConsoleCommandShell((Agent)busMaster);
        comShell.init();
        final JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shell.run();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        });
        t.start();
        while (comShell.getBusMasterCommands().listSubsystems("", "Listener", true).size() != agentCount) {
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)10L, (long)comShell.getBusMasterCommands().listSubsystems().size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "lock_manager", true).size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "lock_manager", false).size());
        Assert.assertEquals((long)4L, (long)comShell.getBusMasterCommands().listSubsystems("", "ocs_bridge", true).size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "ocs_bridge", false).size());
        Assert.assertEquals((long)6L, (long)comShell.getBusMasterCommands().listSubsystems("", "mcm", true).size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "mcm", false).size());
        Assert.assertEquals((long)8L, (long)comShell.getBusMasterCommands().listSubsystems("", "service", true).size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "service", false).size());
        Assert.assertEquals((long)10L, (long)comShell.getBusMasterCommands().listSubsystems("", "Worker", true).size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "Worker", false).size());
        Assert.assertEquals((long)12L, (long)comShell.getBusMasterCommands().listSubsystems("", "Console", true).size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "console", false).size());
        Assert.assertEquals((long)14L, (long)comShell.getBusMasterCommands().listSubsystems("", "Listener", true).size());
        Assert.assertEquals((long)2L, (long)comShell.getBusMasterCommands().listSubsystems("", "Listener", false).size());
        for (i = 0; i < agentCount; ++i) {
            a = (Agent)agents.get(i);
            a.shutdownAgent();
            Thread.sleep(200L);
        }
        Thread.sleep(1000L);
        for (i = 0; i < agentCount; ++i) {
            a = (Agent)agents.get(i);
            Assert.assertTrue((boolean)comShell.getConsoleCommandSet().getCommandSetsForRoute(a.getName()).isEmpty());
        }
        t.interrupt();
        busMaster.shutdownAgent();
        Thread.sleep(200L);
    }
}

