package org.lsst.ccs.subsystems.console.jython;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;

/**
 *
 * @author The LSST CCS Team
 * 
 */
public class JythonScriptExecutor {

    private static CommandLine line;
    static Options shellOptions;
    
    /**
     * @param args the command line arguments
     * @throws org.apache.commons.cli.ParseException
     * @throws java.io.FileNotFoundException
     */
    public static void main(String[] args) throws ParseException, FileNotFoundException, IOException {

        parseCommandLineArguments(args);

        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(80, "ScriptExecutor", "", shellOptions, "", true);
        } else {

            List argList = line.getArgList();
            String scriptPath = null;
            int count = 0;
            String[] arguments = new String[argList.size() -1];
            for ( Object arg : argList ) {
                if ( scriptPath == null ) {
                    scriptPath = (String)arg;
                } else {
                    arguments[count++] = (String)arg;
                }
                
            }
            InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);

            boolean submit = line.hasOption("submit");
            if (submit) {

                int port = 4444;
                if (line.hasOption("jythonPort")) {
                    port = Integer.parseInt(line.getOptionValue("jythonPort"));
                }
                String host = "localhost";
                if (line.hasOption("jythonHost")) {
                    host = line.getOptionValue("jythonHost");
                }

                JythonConsoleSocketConnection jythonConsoleSocketConnection = new JythonConsoleSocketConnection("ScriptSubmission_"+System.currentTimeMillis(),port,host); 
                jythonConsoleSocketConnection.setPrintStream(System.out);
                jythonConsoleSocketConnection.synchFileExecution(is,arguments);
                jythonConsoleSocketConnection.close();
            } else {
                JythonScriptExecutorUtils.executeScript(is,arguments);
            }
        }
        System.exit(0);

    }
    
    
    static void parseCommandLineArguments(String[] args) throws ParseException {
        shellOptions = new Options();
        shellOptions.addOption("h", "help", false, "Print the help message");

        shellOptions.addOption("jhost", "jythonHost", true, "The host of the JythonInterpreterConsole");
        shellOptions.addOption("jport", "jythonPort", true, "The port of the JythonInterpreterConsole");
        shellOptions.addOption("submit", false, "Submit the script to a JythonInterpreterConsole");

        CommandLineParser parser = new BasicParser();
        line = parser.parse(shellOptions, args, true);
    }
    
    static List<String> getLeftoverArguments() {
        return line.getArgList();
    }
    
    
}
