/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;
import org.lsst.ccs.subsystem.tunnel.Tunnel;
import org.lsst.ccs.test.subsystem.PublishSubsystem;

public class ConsoleOverTunnelTest
extends CcsTestCaseTemplate {
    private PublishSubsystem publish;
    private Tunnel tunnel;
    private ConsoleCommandShell console;
    private BusMaster busMaster;

    public ConsoleOverTunnelTest() {
        super("jgroups:udp_ccs:");
    }

    @Before
    public void startAgents() {
        this.publish = new PublishSubsystem("publishSubs");
        this.publish.startAgent();
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.router.host", (String)"localhost");
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.tunnel.start.router", (String)"true");
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.tunnel", (String)"server");
        this.tunnel = new Tunnel();
        this.tunnel.startAgent();
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.tunnel.start.router", (String)"");
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.tunnel", (String)"client");
        this.busMaster = new BusMaster("consoleOverTunnel");
        this.busMaster.startAgent();
        this.console = new ConsoleCommandShell((Agent)this.busMaster);
        this.console.init();
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.tunnel", (String)"");
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.router.host", (String)"");
    }

    @After
    public void stopAgents() throws Exception {
        this.busMaster.shutdownAgent();
        Thread.sleep(100L);
        this.tunnel.shutdownAgent();
        Thread.sleep(100L);
        this.publish.shutdownAgent();
    }

    @Test
    public void testExchange() throws Exception {
        TunnelClientListener listener = new TunnelClientListener();
        this.busMaster.getMessagingAccess().addStatusMessageListener((StatusMessageListener)listener);
        Thread.sleep(2000L);
        TunnelCommandOriginator originator = new TunnelCommandOriginator();
        CommandRequest request = new CommandRequest("publishSubs", "ping");
        this.busMaster.getMessagingAccess().sendCommandRequest(request, (CommandOriginator)originator);
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)originator.gotAck);
        Assert.assertTrue((boolean)originator.gotResult);
        Assert.assertTrue((listener.nStatus > 0 ? 1 : 0) != 0);
        Thread.sleep(20000L);
    }

    private class TunnelCommandOriginator
    implements CommandOriginator {
        boolean gotAck = false;
        boolean gotResult = false;

        private TunnelCommandOriginator() {
        }

        public void processAck(CommandAck ack) {
            this.gotAck = true;
        }

        public void processNack(CommandNack nack) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void processResult(CommandResult result) {
            this.gotResult = true;
        }
    }

    private class TunnelClientListener
    implements StatusMessageListener {
        int nStatus = 0;

        private TunnelClientListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            ++this.nStatus;
        }
    }
}

