package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.HashMap;
import java.util.Map;

/**
 * A class to efficiently count occurrences.
 * It internally contains a map with String keys. It is designed to increment
 * by one the occurrence of one given event identified by a given key.
 * 
 * @author The LSST CCS Team
 */
class Counter {
    
    private final Map<String, int[]> counterMap = new HashMap<>();
    
    /**
     * Increment the occurrence of the given key by one.
     * @param key The key to increment.
     */
    public synchronized void increment(String key) {
        int[] valueWrapper = counterMap.get(key);

        if (valueWrapper == null) {
            counterMap.put(key, new int[]{1});
        } else {
            valueWrapper[0]++;
        }
    }
    
    /**
     * Get the Map with the counters.
     * 
     * @return The Map with the counters.
     */
    public Map<String,Integer> getCountersMap() {
        Map<String,Integer> result = new HashMap();
        for ( String key: counterMap.keySet()) {
            result.put(key, counterMap.get(key)[0]);
        }
        return result;
    }
}
