package org.lsst.ccs.subsystem.shell;

import java.util.List;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.services.AgentLockService;

/**
 * Commands for agent lock service.
 * @author emarin
 */
public class AgentLockServiceCommands {
    
    private final AgentLockService als;
    private final RouteSelectionCommandSet rsc;
    
    AgentLockServiceCommands(AgentLockService als, RouteSelectionCommandSet rsc) {
        this.als = als;
        this.rsc = rsc;
    }
    
    @Command(description = "Set this agent's authorized operational level for the given subsystem")
    public void setLevel(@Argument(allowedValueProvider = "getAllWorkerAgents") String agentName, int level) throws Exception {
        System.out.println("DEPRECATED: use \"set level AGENT_NAME LEVEL\" instead");
        als.setLevelForAgent(agentName, level);
    }
    
    @Command(description = "Get this agent's authorized operatinal level for the given subsystem")
    public int getLevel(@Argument(allowedValueProvider = "getAllWorkerAgents") String agentName) {
        System.out.println("DEPRECATED: use \"get level AGENT_NAME\" instead");
        return als.getLevelForAgent(agentName);
    }
    
    public enum SetGetLevelCommands {
        LEVEL
    };


    @Command(description = "Set the level of an agent", level = Command.NORMAL)
    public void set(@Argument(name = "item") SetGetLevelCommands what, @Argument(allowedValueProvider = "getAllWorkerAgents") String agentName, int level) throws Exception {
        switch (what) {
            case LEVEL:
                als.setLevelForAgent(agentName, level);
        }
    }

    @Command(description = "Set the level of an agent", level = Command.NORMAL)
    public void set(@Argument(name = "item") SetGetLevelCommands what, int level) throws Exception {
        String agentName = rsc.getActiveRoute();
        if ( agentName.contains("/") ) {
            agentName = agentName.substring(0,agentName.indexOf("/"));
        }
        set(what,agentName,level);
    }

    @Command(description = "Get the level of an agent", level = Command.NORMAL)
    public int get(@Argument(name = "item") SetGetLevelCommands what, @Argument(allowedValueProvider = "getAllWorkerAgents") String agentName) throws Exception {
        switch (what) {
            case LEVEL:
                return als.getLevelForAgent(agentName);
        }
        return -1;
    }
    
    @Command(description = "Get the level of an agent", level = Command.NORMAL)
    public int get(@Argument(name = "item") SetGetLevelCommands what) throws Exception {
        String agentName = rsc.getActiveRoute();
        if ( agentName.contains("/") ) {
            agentName = agentName.substring(0,agentName.indexOf("/"));
        }
        return get(what,agentName);
    }
        
    @Command(description = "Lock the given subsystem")
    public void lock(@Argument(allowedValueProvider = "getLockableAgents", defaultValue = "CurrentTarget") String agentName) throws Exception {
        if ( agentName.equals("CurrentTarget") ) {
            agentName = rsc.getActiveRoute();
            if (agentName.contains("/")) {
                agentName = agentName.substring(0, agentName.indexOf("/"));
            }
        }
        als.lockAgent(agentName);
    }
    
    @Command(description = "Unlock the given subsystem")
    public void unlock(@Argument(allowedValueProvider = "getLockedAgents", defaultValue = "CurrentTarget") String agentName) throws Exception {
        if ( agentName.equals("CurrentTarget") ) {
            agentName = rsc.getActiveRoute();
            if (agentName.contains("/")) {
                agentName = agentName.substring(0, agentName.indexOf("/"));
            }
        }
        als.unlockAgent(agentName);
    }

    @Command(description = "Show locked agents")
    public List<String> getLockedAgents() {
        return als.getLockedAgents();
    }
    
    @Command(description = "Show agents that could be locked")
    public List<String> getLockableAgents() {
        return als.getLockableAgents();
    }
    
    public List<String> getAllWorkerAgents() {
        return als.getAllWorkerAgents();
    }
    
}
