package org.lsst.ccs.subsystem.shell;

import java.util.List;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.services.AgentLockService;

/**
 * Commands for agent lock service.
 * @author emarin
 */
public class AgentLockServiceCommands {
    
    private final AgentLockService als;
    
    AgentLockServiceCommands(AgentLockService als) {
        this.als = als;
    }
    
    @Command(description = "Set this agent's authorized operational level for the given subsystem")
    public void setLevel(@Argument(allowedValueProvider = "getAllWorkerAgents") String agentName, int level) throws Exception {
        als.setLevelForAgent(agentName, level);
    }
    
    @Command(description = "Get this agent's authorized operatinal level for the given subsystem")
    public int getLevel(@Argument(allowedValueProvider = "getAllWorkerAgents") String agentName) {
        return als.getLevelForAgent(agentName);
    }
    
    @Command(description = "Lock the given subsystem")
    public void lock(@Argument(allowedValueProvider = "getLockableAgents") String agentName) throws Exception {
        als.lockAgent(agentName);
    }
    
    @Command(description = "Unlock the given subsystem")
    public void unlock(@Argument(allowedValueProvider = "getLockedAgents") String agentName) throws Exception {
        als.unlockAgent(agentName);
    }

    @Command(description = "Show locked agents")
    public List<String> getLockedAgents() {
        return als.getLockedAgents();
    }
    
    @Command(description = "Show agents that could be locked")
    public List<String> getLockableAgents() {
        return als.getLockableAgents();
    }
    
    public List<String> getAllWorkerAgents() {
        return als.getAllWorkerAgents();
    }
    
}
