package org.lsst.ccs.subsystem.cluster.monitor;

import java.util.HashMap;
import java.util.Map;

/**
 * A class to efficiently accumulate values.
 * It internally contains a map with String keys. It is designed to increment
 * by a given value the entity identified by a given key.
 * 
 * @author The LSST CCS Team
 */
class Accumulate {
    
    private final Map<String, double[]> accumulateMap = new HashMap<>();
    private final Counter counter = new Counter();
    
    /**
     * Add to the existing value of the given key by one.
     * @param key The key to increment.
     */
    public synchronized void accumulate(double value, String key) {
        double[] valueWrapper = accumulateMap.get(key);
        counter.increment(key);

        if (valueWrapper == null) {
            accumulateMap.put(key, new double[]{value});
        } else {
            valueWrapper[0] += value;
        }
    }
    
    /**
     * Get the Map with the counters.
     * 
     * @return The Map with the counters.
     */
    public Map<String,Double> getAverageMap() {
        Map<String,Double> result = new HashMap();
        for ( String key: accumulateMap.keySet()) {
            result.put(key, accumulateMap.get(key)[0]/counter.getCountersMap().get(key));
        }
        return result;
    }
}
