/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

public class TestDictionaryStructure
extends CcsTestCaseTemplate {
    @Test
    public void testDictionaryStructure() throws Exception {
        BusMaster busMaster = new BusMaster("console");
        busMaster.startAgent();
        ConsoleCommandShell comShell = new ConsoleCommandShell(busMaster.getMessagingAccess());
        comShell.init();
        Subsystem s = BootUtils.getSubsystemFromFile((String)"simpleModuleWithDeepStructure");
        String sName = s.getName();
        s.startAgent();
        while (!busMaster.getMessagingAccess().getAgentPresenceManager().agentExists(sName) && !comShell.getRoutes().containsKey(sName)) {
            Thread.sleep(10L);
        }
        Thread.sleep(200L);
        Map routes = comShell.getRoutes();
        Set routesSet = routes.keySet();
        Assert.assertEquals((String)routesSet.toString(), (long)12L, (long)routesSet.size());
        Assert.assertTrue((boolean)routesSet.contains(sName));
        Assert.assertTrue((boolean)routesSet.contains(sName + "/childModule"));
        Assert.assertTrue((boolean)routesSet.contains(sName + "/c1"));
        Assert.assertTrue((boolean)routesSet.contains(sName + "/c2"));
        Assert.assertFalse((boolean)routesSet.contains(sName + "/childConfigurable"));
        comShell.getConsoleCommandSet().invoke((BasicCommand)new TokenizedCommand("set target " + sName));
        Object al = comShell.getConsoleCommandSet().invoke((BasicCommand)new TokenizedCommand("getRaisedAlertSummary"));
        Assert.assertTrue((boolean)(al instanceof RaisedAlertSummary));
        Object obj = comShell.getConsoleCommandSet().invoke((BasicCommand)new TokenizedCommand("set target " + sName + "/c1"));
        s.shutdownAgent();
        busMaster.shutdownAgent();
    }
}

