package org.lsst.ccs.subsystem.shell;

import java.time.Duration;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

/**
 * A command set which invokes commands by sending messages on the CCS 
 * command bus.
 * @author tonyj
 */
class BusCommandSet implements CommandSet {

    private final String dictionaryPath;
    private final Dictionary dict;
    private final ConcurrentMessagingUtils sci;

    BusCommandSet(ConcurrentMessagingUtils sci, String dictionaryPath, Dictionary dict) {
        this.sci = sci;
        this.dictionaryPath = dictionaryPath;
        this.dict = dict;
    }

    @Override
    public Dictionary getCommandDictionary() {
        return dict;
    }

    @Override
    public Object invoke(BasicCommand bc) throws CommandInvocationException, CommandArgumentMatchException {

        DictionaryCommand findCommand = dict.findCommand(bc);
        if (findCommand == null) {
            throw new CommandInvocationException("No handler found for command %s with %d arguments", bc.getCommand(), bc.getArgumentCount());
        }
        CommandRequest basicCommandBusMessage = new CommandRequest(dictionaryPath, bc);

        try {
            return sci.sendSynchronousCommand(basicCommandBusMessage);
        } catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command: "+ex.getMessage(), ex);
        }
    }

}
