/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class MonitorTrendingTable
extends JPanel {
    static final String[] colNames = new String[]{"Description", "Value", "Units", "Low Limit", "High Limit", "Name"};
    static final Class[] colTypes = new Class[]{String.class, TrendingValue.class, String.class, Double.class, Double.class, String.class};
    static final boolean[] colCanEdit;
    static final Color colGood;
    static final Color colError;
    static final Color colOffln;
    static final Font myFont;
    static final Font changeFont;
    static final int DESCRIPTION_IND = 0;
    static final int VALUE_IND = 1;
    static final int UNITS_IND = 2;
    static final int LOW_LIMIT_IND = 3;
    static final int HIGH_LIMIT_IND = 4;
    static final int NAME_IND = 5;
    CommandSender sender;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    static {
        boolean[] blArray = new boolean[6];
        blArray[3] = true;
        blArray[4] = true;
        colCanEdit = blArray;
        colGood = new Color(160, 255, 160);
        colError = new Color(255, 160, 160);
        colOffln = new Color(160, 160, 255);
        myFont = new Font("Helvetica", 0, 12);
        changeFont = new Font("Helvetica", 1, 12);
    }

    public MonitorTrendingTable(CommandSender sender) {
        this.initComponents();
        JTableHeader hdr = this.jTable1.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        this.jTable1.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
        this.jTable1.setDefaultRenderer(Double.class, new LimitsCellRenderer());
        this.jTable1.setDefaultRenderer(String.class, new TextCellRenderer());
        this.jTable1.setAutoResizeMode(3);
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setFont(myFont);
        this.jTable1.setRowHeight(this.jTable1.getRowHeight() + 2);
        this.sender = sender;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.jTable1.setModel(new TrendingTableModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1);
    }

    public void updateTableModel(MonitorFullState status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(status));
    }

    public void updateTableValue(MonitorState status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableState(status));
    }

    public void updateTableValue(TrendingStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTable(status));
    }

    public void updateTableValue(MetadataStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableLimits(status));
    }

    private static String fmt(double val) {
        return String.format("%.2f  ", val);
    }

    class LimitsCellRenderer
    extends DefaultTableCellRenderer {
        LimitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, MonitorTrendingTable.fmt((Double)value), isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if (column == 3 && model.hasLowLimitChanged(row) || column == 4 && model.hasHighLimitChanged(row)) {
                c.setFont(changeFont);
                c.setForeground(Color.blue);
            } else {
                c.setForeground(Color.black);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            return c;
        }
    }

    class TextCellRenderer
    extends DefaultTableCellRenderer {
        TextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, "  " + (String)value, isSelected, hasFocus, row, column);
        }
    }

    class TrendingTableCellRenderer
    extends DefaultTableCellRenderer {
        TrendingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, MonitorTrendingTable.fmt((Double)value), isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if (column == 1) {
                int state = model.getChannelState(row);
                c.setBackground(state > 0 ? colGood : (state == 0 ? colError : colOffln));
            } else {
                c.setBackground(Color.white);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            return c;
        }
    }

    class TrendingTableModel
    extends DefaultTableModel
    implements TableModelListener {
        List<Double> lowLimits;
        List<Double> highLimits;
        Map<String, Integer> chanMap;
        BitSet goodChans;
        BitSet onlineChans;
        BitSet lowLimitChange;
        BitSet highLimitChange;

        public TrendingTableModel() {
            super(colNames, 0);
            this.lowLimits = new ArrayList<Double>();
            this.highLimits = new ArrayList<Double>();
            this.chanMap = new HashMap<String, Integer>();
            this.goodChans = new BitSet();
            this.onlineChans = new BitSet();
            this.lowLimitChange = new BitSet();
            this.highLimitChange = new BitSet();
            this.addTableModelListener(this);
        }

        public Class getColumnClass(int columnIndex) {
            return colTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return colCanEdit[columnIndex];
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            double oldValue;
            int column = e.getColumn();
            if (column != 3 && column != 4) {
                return;
            }
            int row = e.getFirstRow();
            boolean isLow = column == 3;
            double newValue = (Double)this.getValueAt(row, column);
            double d = oldValue = isLow ? this.getLowLimit(row) : this.getHighLimit(row);
            if (newValue != oldValue) {
                this.setValueAt(oldValue, row, column);
                this.submitLimit((String)this.getValueAt(row, 5), newValue, isLow);
            }
        }

        void addTrendingRow(MonitorChan chan) {
            this.chanMap.put(chan.getName(), this.lowLimits.size());
            this.lowLimits.add(chan.getLowLimit());
            this.highLimits.add(chan.getHighLimit());
            this.addRow(new Object[]{chan.getDescription(), chan.getValue(), chan.getUnits(), chan.getLowLimit(), chan.getHighLimit(), chan.getName()});
        }

        void updateValues(TrendingStatus s) {
            List vnl = (List)s.getValue();
            int row = 0;
            while (row < this.getRowCount()) {
                this.setValueAt(((ValueNotification)vnl.get(row)).getData(), row, 1);
                ++row;
            }
        }

        void updateState(MonitorState s) {
            this.goodChans = s.getGoodChans();
            this.onlineChans = s.getOnlineChans();
            this.getRowCount();
            BitSet update = (BitSet)s.getLowLimitChange().clone();
            update.xor(this.lowLimitChange);
            this.lowLimitChange.xor(update);
            int row = update.nextSetBit(0);
            while (row >= 0) {
                this.setValueAt(this.getLowLimit(row), row, 3);
                row = update.nextSetBit(row + 1);
            }
            update = (BitSet)s.getHighLimitChange().clone();
            update.xor(this.highLimitChange);
            this.highLimitChange.xor(update);
            row = update.nextSetBit(0);
            while (row >= 0) {
                this.setValueAt(this.getHighLimit(row), row, 4);
                row = update.nextSetBit(row + 1);
            }
        }

        void updateLimit(MetadataStatus s) {
            boolean high = s.getMetadataName().equals("alarmHigh");
            double limit = Double.valueOf(s.getMetadataValue());
            int row = this.chanMap.get(s.getDataName());
            if (high) {
                this.setHighLimit(row, limit);
            } else {
                this.setLowLimit(row, limit);
            }
        }

        boolean isValueWithinLimits(int row) {
            return this.goodChans.get(row);
        }

        int getChannelState(int row) {
            return !this.onlineChans.get(row) ? -1 : (!this.goodChans.get(row) ? 0 : 1);
        }

        void setLowLimit(int row, double value) {
            this.lowLimits.set(row, value);
            this.setValueAt(value, row, 3);
        }

        void setHighLimit(int row, double value) {
            this.highLimits.set(row, value);
            this.setValueAt(value, row, 4);
        }

        double getLowLimit(int row) {
            return this.lowLimits.get(row);
        }

        double getHighLimit(int row) {
            return this.highLimits.get(row);
        }

        boolean hasLowLimitChanged(int row) {
            return this.lowLimitChange.get(row);
        }

        boolean hasHighLimitChanged(int row) {
            return this.highLimitChange.get(row);
        }

        void submitLimit(String name, double value, boolean isLowLimit) {
            String param = isLowLimit ? "limitLo" : "limitHi";
            MonitorTrendingTable.this.sender.sendCommand(name, (Command)new ModuleInvokerCommand(null, "change", new Object[]{param, value}));
        }
    }

    class TrendingValue {
        TrendingValue() {
        }
    }

    class UpdateTrendingTable
    implements Runnable {
        TrendingStatus s;

        UpdateTrendingTable(TrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel()).updateValues(this.s);
        }
    }

    class UpdateTrendingTableLimits
    implements Runnable {
        MetadataStatus s;

        UpdateTrendingTableLimits(MetadataStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel()).updateLimit(this.s);
        }
    }

    class UpdateTrendingTableModel
    implements Runnable {
        MonitorFullState s;

        UpdateTrendingTableModel(MonitorFullState s) {
            this.s = s;
        }

        @Override
        public void run() {
            List<MonitorChan> channels = this.s.getChannels();
            TrendingTableModel model = new TrendingTableModel();
            MonitorTrendingTable.this.jTable1.setModel(model);
            model.updateState(this.s.getMonitorState());
            for (MonitorChan chan : channels) {
                model.addTrendingRow(chan);
            }
            int c = 0;
            while (c < MonitorTrendingTable.this.jTable1.getColumnCount()) {
                TableColumnModel colModel = MonitorTrendingTable.this.jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr = MonitorTrendingTable.this.jTable1.getTableHeader().getDefaultRenderer();
                Component comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.jTable1, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                rndr = MonitorTrendingTable.this.jTable1.getCellRenderer(0, c);
                Class<?> colClass = MonitorTrendingTable.this.jTable1.getColumnClass(c);
                if (!colClass.equals(String.class)) {
                    comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.jTable1, -999.99, false, false, 0, c);
                    width = Math.max(width, comp.getPreferredSize().width);
                } else {
                    int r = 0;
                    while (r < MonitorTrendingTable.this.jTable1.getRowCount()) {
                        Object value = MonitorTrendingTable.this.jTable1.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(MonitorTrendingTable.this.jTable1, value, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                        ++r;
                    }
                }
                col.setPreferredWidth(width + 4);
                ++c;
            }
        }
    }

    class UpdateTrendingTableState
    implements Runnable {
        MonitorState s;

        UpdateTrendingTableState(MonitorState s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)MonitorTrendingTable.this.jTable1.getModel()).updateState(this.s);
        }
    }
}

