package org.lsst.ccs.subsystem.monitor.data;

import java.io.Serializable;
import java.util.BitSet;

/**
 ***************************************************************************
 **
 **  Contains the state of the monitoring system.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MonitorState implements Serializable {

    private static final long serialVersionUID = -5401760505917827282L;

    public static final String KEY = "MonitorState";

    BitSet goodChans,          //  Good channels
           onlineChans,        //  Online channels
           lowLimitChange,     //  Channels with low limit changes
           highLimitChange;    //  Channels with high limit changes

    public MonitorState(BitSet goodChans, BitSet onlineChans,
                        BitSet lowLimitChange, BitSet highLimitChange)
    {
        this.goodChans       = goodChans;
        this.onlineChans     = onlineChans;
        this.lowLimitChange  = lowLimitChange;
        this.highLimitChange = highLimitChange;
    }
    
    public BitSet getGoodChans()
    {
        return goodChans;
    }

    public BitSet getOnlineChans()
    {
        return onlineChans;
    }

    public BitSet getLowLimitChange()
    {
        return lowLimitChange;
    }

    public BitSet getHighLimitChange()
    {
        return highLimitChange;
    }

    @Override
    public String toString()
    {
        return "goodChans=" + goodChans
                + ", onlineChans=" + onlineChans
                + ", lowLimitChange=" + lowLimitChange
                + ", highLimitChange=" + highLimitChange;
    }

}
