/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.CalcDevice;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.status.MonitorStateStatus;
import org.lsst.ccs.utilities.logging.Logger;

public class Monitor {
    static final long DEFAULT_UPDATE_PERIOD = 1000L;
    static final long CHECK_PERIOD = 10000L;
    static final String CALC_DEVICE_NAME = "Calc";
    int numChans;
    Map<String, Device> devcMap;
    Map<String, Channel> chanMap;
    Map<String, Alarm> alarmMap;
    Map<String, Line> lineMap;
    CalcDevice calcDevc = new CalcDevice();
    List<Device> devcList = new ArrayList<Device>();
    List<Alarm> alarmList = new ArrayList<Alarm>();
    Channel[] chanData;
    BitSet loLimChange = new BitSet();
    BitSet hiLimChange = new BitSet();
    BitSet goodChans = new BitSet();
    BitSet onlineChans = new BitSet();
    Module module;
    AlarmHandler alarmH;
    Logger log;
    Subsystem subsys;

    public Monitor(Module mod, AlarmHandler alarmHand, Logger logger) {
        this.devcMap = mod.getEnvironment().getChildren(Device.class);
        this.chanMap = mod.getEnvironment().getChildren(Channel.class);
        this.alarmMap = mod.getEnvironment().getChildren(Alarm.class);
        this.lineMap = mod.getEnvironment().getChildren(Line.class);
        this.module = mod;
        this.alarmH = alarmHand;
        this.log = logger;
        this.subsys = this.module.getSubsystem();
    }

    public void initConfiguration() {
        this.devcMap.put(CALC_DEVICE_NAME, this.calcDevc);
        for (Device devc : this.devcMap.values()) {
            this.devcList.add(devc);
            devc.configure(this);
        }
        for (Line line : this.lineMap.values()) {
            line.configure(this);
        }
        for (Alarm alarm : this.alarmMap.values()) {
            this.alarmList.add(alarm);
            alarm.configure(this);
        }
        this.chanData = new Channel[this.chanMap.size()];
        int id = 0;
        for (Channel ch : this.chanMap.values()) {
            ch.configure(this, id);
            this.chanData[id++] = ch;
        }
        this.calcDevc.configChans();
    }

    public void initSensors() {
        for (Device devc : this.devcList) {
            devc.initialize();
        }
        for (Alarm alarm : this.alarmList) {
            alarm.initialize();
        }
        new Timer(true).schedule((TimerTask)new CheckDevices(), 0L, 10000L);
    }

    public void readSensors() {
        for (Device devc : this.devcList) {
            devc.readSensors();
        }
    }

    public void start() {
        this.start(1000L);
    }

    public void start(long period) {
        new Timer(true).schedule((TimerTask)new UpdateState(), 0L, period);
    }

    public MonitorFullState getFullState() {
        MonitorFullState state = new MonitorFullState();
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            state.addChannel(new MonitorChan(ch.getName(), ch.description, ch.units, ch.limitLo, ch.limitHi, ch.value));
            ++n2;
        }
        state.setMonitorState(new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange));
        return state;
    }

    public void publishState() {
        MonitorState state = new MonitorState(this.goodChans, this.onlineChans, this.loLimChange, this.hiLimChange);
        this.module.sendToStatus((Status)new MonitorStateStatus(state));
    }

    public void publishData() {
        long timeStamp = System.currentTimeMillis();
        ArrayList<ValueNotification> values = new ArrayList<ValueNotification>();
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            values.add(new ValueNotification(ch.name, (Object)ch.value, timeStamp));
            ++n2;
        }
        this.module.publishData(values);
    }

    public void publishLimits() {
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            this.subsys.publishMetaData(ch.getName(), "alarmLow", String.valueOf(ch.limitLo));
            this.subsys.publishMetaData(ch.getName(), "alarmHigh", String.valueOf(ch.limitHi));
            ++n2;
        }
    }

    public void checkLimits() {
        BitSet chanState = new BitSet(this.numChans);
        Channel[] channelArray = this.chanData;
        int n = this.chanData.length;
        int n2 = 0;
        while (n2 < n) {
            Channel ch = channelArray[n2];
            ch.checkLimits(chanState);
            ++n2;
        }
        for (Alarm alarm : this.alarmList) {
            alarm.setState();
        }
        chanState.xor(this.goodChans);
        this.goodChans.xor(chanState);
        if (!chanState.isEmpty()) {
            this.publishState();
            this.publishData();
        }
    }

    public void clearLimitChanges() {
        this.loLimChange.clear();
        this.hiLimChange.clear();
    }

    public Device getDevice(String name) {
        return this.devcMap.get(name);
    }

    public Line getLine(String name) {
        return this.lineMap.get(name);
    }

    public Alarm getAlarm(String name) {
        return this.alarmMap.get(name);
    }

    public Channel getChannel(String name) {
        return this.chanMap.get(name);
    }

    public Channel getChannel(int id) {
        return this.chanData[id];
    }

    public int getChannelId(String name) {
        Channel chan = this.chanMap.get(name);
        return chan == null ? -1 : chan.id;
    }

    public void setOnline(BitSet mask, boolean online) {
        BitSet prevOnline = (BitSet)this.onlineChans.clone();
        if (online) {
            this.onlineChans.or(mask);
        } else {
            this.onlineChans.andNot(mask);
        }
        if (!this.onlineChans.equals(prevOnline)) {
            this.publishState();
        }
    }

    public int getNumChans() {
        return this.numChans;
    }

    public Module getModule() {
        return this.module;
    }

    public void reportError(String cName, String pName, Object pValue) throws Exception {
        this.log.error((Object)("Invalid " + pName + " (" + pValue + ") for " + cName), new String[0]);
        throw new Exception();
    }

    public void reportConfigError(String cName, String pName, String message) {
        this.log.error((Object)("Configuration parameter " + pName + " for " + cName + " " + message), new String[0]);
        try {
            this.module.getSubsystem().shutdown();
        }
        catch (HardwareException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static interface AlarmHandler {
        public void processAlarm(int var1, int var2);
    }

    private class CheckDevices
    extends TimerTask {
        private CheckDevices() {
        }

        @Override
        public void run() {
            for (Device devc : Monitor.this.devcList) {
                devc.checkOnline();
            }
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            Monitor.this.readSensors();
            Monitor.this.checkLimits();
        }
    }
}

