/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class Line
extends ConfigurableComponent {
    String devcName;
    int chan;
    String devcNameC;
    int chanC;
    Device device;
    Device deviceC;

    public Line(String devcName, int chan, String devcNameC, int chanC) {
        this.devcName = devcName;
        this.chan = chan;
        this.devcNameC = devcNameC;
        this.chanC = chanC;
    }

    void configure(Monitor mon) {
        try {
            if (this.devcName != null) {
                this.device = mon.getDevice(this.devcName);
                if (this.device == null) {
                    mon.reportError(this.getName(), "device", this.devcName);
                }
                this.device.checkLine(this.getName(), this.chan);
            }
            if (this.devcNameC != null) {
                this.deviceC = mon.getDevice(this.devcNameC);
                if (this.deviceC == null) {
                    mon.reportError(this.getName(), "device", this.devcNameC);
                }
                this.deviceC.checkLine(this.getName(), this.chanC);
            }
        }
        catch (Exception exception) {}
    }

    public void setWarm(boolean on) {
        if (this.device != null) {
            this.device.setLineWarm(this.chan, on);
        }
        if (this.deviceC != null) {
            this.deviceC.setLineWarm(this.chanC, !on);
        }
    }

    public void set(boolean on) {
        if (this.device != null && this.device.online) {
            this.device.setLine(this.chan, on);
        }
        if (this.deviceC != null && this.deviceC.online) {
            this.deviceC.setLine(this.chanC, !on);
        }
    }

    public boolean isSet() {
        boolean state = false;
        if (this.device != null && this.device.online) {
            state = this.device.isLineSet(this.chan);
        } else if (this.deviceC != null && this.deviceC.online) {
            state = !this.deviceC.isLineSet(this.chanC);
        }
        return state;
    }
}

