package org.lsst.ccs.subsystem.monitor.status;

import org.lsst.ccs.bus.Status;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

/**
 ***************************************************************************
 **
 **  Contains the state of the monitoring system.
 **
 **  Sent on the status bus whenever the state changes
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MonitorStateStatus extends Status {

    private static final long serialVersionUID = 7305039076717068776L;
    
    private MonitorState monState;

    public MonitorStateStatus(MonitorState monState)
    {
        super();
        this.monState = monState;
    }
    
    public MonitorState getMonitorState()
    {
        return monState;
    }

    @Override
    public String toString()
    {
        return "MonitorStateStatus(" + origin + ") @" + timeStamp + " : ["
                 + state + "] " + summary + " (" + monState + ")";
    }

}
