package org.lsst.ccs.subsystem.monitor;

import org.lsst.ccs.framework.ConfigurableComponent;

/**
 ***************************************************************************
 **
 **  Implements hardware output lines.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class Line extends ConfigurableComponent {

   /**
    ***********************************************************************
    **
    **  Data fields.
    **
    ***********************************************************************
    */
    // Supplied immutable fields
    String    devcName;    // Device name
    int       chan;        // HW channel number
    String    devcNameC;   // Complementary device name
    int       chanC;       // Complementary HW channel number

    // Derived immutable fields
    Device    device;      // Device for this line
    Device    deviceC;     // Device for the complementary line


   /**
    ***********************************************************************
    **
    **  Constructor.
    **
    ***********************************************************************
    */
    public Line(String devcName, int chan, String devcNameC, int chanC)
    {
        this.devcName  = devcName;
        this.chan      = chan;
        this.devcNameC = devcNameC;
        this.chanC     = chanC;
    }


   /**
    ***********************************************************************
    **
    **  Configures the line.
    **
    ***********************************************************************
    */
    void configure(Monitor mon)
    {
        try {
            if (devcName != null) {
                device = mon.getDevice(devcName);
                if (device == null) {
                    mon.reportError(getName(), "device", devcName);
                }
                device.checkLine(getName(), chan);
            }
            if (devcNameC != null) {
                deviceC = mon.getDevice(devcNameC);
                if (deviceC == null) {
                    mon.reportError(getName(), "device", devcNameC);
                }
                deviceC.checkLine(getName(), chanC);
            }
        }
        catch(Exception e) {
        }
    }


   /**
    ***********************************************************************
    **
    **  Sets the warm-start state of the line.
    **
    ***********************************************************************
    */
    public void setWarm(boolean on)
    {
        if (device != null) {
            device.setLineWarm(chan, on);
        }
        if (deviceC != null) {
            deviceC.setLineWarm(chanC, !on);
        }
    }


   /**
    ***********************************************************************
    **
    **  Sets the line value.
    **
    ***********************************************************************
    */
    public void set(boolean on)
    {
        if (device != null && device.online) {
            device.setLine(chan, on);
        }
        if (deviceC != null && deviceC.online) {
            deviceC.setLine(chanC, !on);
        }
    }


   /**
    ***********************************************************************
    **
    **  Gets the line value.
    **
    ***********************************************************************
    */
    public boolean isSet()
    {
        boolean state = false;
        if (device != null && device.online) {
            state = device.isLineSet(chan);
        }
        else if (deviceC != null && deviceC.online) {
            state = !deviceC.isLineSet(chanC);
        }

        return state;
    }

}
