/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.utilities.logging.Logger;

public class Channel
extends ConfigurableComponent {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_TEMP = 0;
    public static final int TYPE_VOLTS = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_SWITCH = 3;
    public static final int TYPE_DIFF = 4;
    static final int LIMIT_CHECK_NONE = 0;
    static final int LIMIT_CHECK_FLAG = 1;
    static final int LIMIT_CHECK_ALARM = 2;
    private static final Map<String, Integer> checkMap = new HashMap<String, Integer>();
    String description;
    String units;
    String devcName;
    int hwChan;
    String typeS;
    String subtypeS;
    double offset;
    double scale;
    String checkLoS;
    String alarmLoS;
    String checkHiS;
    String alarmHiS;
    double limitLo;
    double limitHi;
    String name;
    Device devc;
    int type;
    int subtype;
    int checkLo;
    double resetLo;
    Alarm alarmLo;
    int checkHi;
    double resetHi;
    Alarm alarmHi;
    int id;
    boolean valid;
    Monitor mon;
    Logger log;
    double value;

    static {
        checkMap.put("NONE", 0);
        checkMap.put("FLAG", 1);
        checkMap.put("ALARM", 2);
    }

    public Channel(String desc, String unit, String devName, int chan, String type, String subtype, double offs, double scal, String checkLo, double limLo, double deadbandLo, String alarmLo, String checkHi, double limHi, double deadbandHi, String alarmHi) {
        this.description = desc;
        this.units = unit;
        this.devcName = devName;
        this.hwChan = chan;
        this.typeS = type;
        this.subtypeS = subtype;
        this.offset = offs;
        this.scale = scal;
        this.checkLoS = checkLo;
        this.limitLo = limLo;
        this.resetLo = deadbandLo <= 0.0 ? this.limitLo : this.limitLo + deadbandLo;
        this.alarmLoS = alarmLo;
        this.checkHiS = checkHi;
        this.limitHi = limHi;
        this.resetHi = deadbandHi <= 0.0 ? this.limitHi : this.limitHi - deadbandHi;
        this.alarmHiS = alarmHi;
    }

    void configure(Monitor mon, int id) {
        this.name = this.getName();
        this.mon = mon;
        this.id = id;
        this.log = mon.log;
        this.checkLo = 1;
        this.checkHi = 1;
        this.type = -1;
        this.subtype = -1;
        try {
            Integer iCheck;
            if (this.devcName == null) {
                this.devcName = "Calc";
            }
            this.devc = mon.getDevice(this.devcName);
            if (this.devc == null) {
                mon.reportError(this.name, "device name", this.devcName);
            }
            if ((iCheck = checkMap.get(this.checkLoS.toUpperCase())) == null) {
                mon.reportError(this.name, "low check option", this.checkLoS);
            }
            this.checkLo = iCheck;
            iCheck = checkMap.get(this.checkHiS.toUpperCase());
            if (iCheck == null) {
                mon.reportError(this.name, "high check option", this.checkHiS);
            }
            this.checkHi = iCheck;
            if (this.alarmLoS != null) {
                this.alarmLo = mon.getAlarm(this.alarmLoS);
            }
            if (this.alarmLo == null && (this.checkLo == 2 || this.alarmLoS != null)) {
                mon.reportError(this.name, "low alarm name", this.alarmLoS);
            }
            if (this.alarmHiS != null) {
                this.alarmHi = mon.getAlarm(this.alarmHiS);
            }
            if (this.alarmHi == null && (this.checkHi == 2 || this.alarmHiS != null)) {
                mon.reportError(this.name, "high alarm name", this.alarmHiS);
            }
            int[] types = this.devc.checkChannel(this.name, this.hwChan, this.typeS, this.subtypeS);
            this.type = types[0];
            this.subtype = types[1];
            this.valid = true;
            this.devc.addChannel(id);
        }
        catch (Exception exception) {}
    }

    void configCalc() {
        String[] names = this.subtypeS.split(":", -1);
        int id0 = 0;
        int id1 = 0;
        try {
            if (names.length != 2 || (id0 = this.mon.getChannelId(names[0])) < 0 || (id1 = this.mon.getChannelId(names[1])) < 0) {
                this.mon.reportError(this.name, "subtype", this.subtypeS);
            }
            this.subtype = id0 << 16 | id1;
        }
        catch (Exception exception) {
            this.valid = false;
            this.devc.dropChannel(this.id);
        }
    }

    void initSensor() {
        if (!this.valid) {
            return;
        }
        this.devc.initChannel(this.hwChan, this.type, this.subtype);
    }

    void readSensor() {
        if (!this.valid) {
            return;
        }
        this.value = this.devc != this.mon.calcDevc ? this.offset + this.scale * this.devc.readChannel(this.hwChan, this.type) : this.mon.getChannel((int)(this.subtype >> 16)).value - this.mon.getChannel((int)(this.subtype & 0xFFFF)).value;
    }

    void checkLimits(BitSet cState) {
        if (!this.valid) {
            return;
        }
        boolean ok = true;
        if (this.value < this.limitLo) {
            if (this.checkLo != 0) {
                ok = false;
                if (this.checkLo == 2) {
                    this.alarmLo.updateState(2);
                }
            }
        } else if (this.value > this.limitHi) {
            if (this.checkHi != 0) {
                ok = false;
                if (this.checkHi == 2) {
                    this.alarmHi.updateState(2);
                }
            }
        } else {
            if (this.checkLo == 2) {
                this.alarmLo.updateState(this.value >= this.resetLo ? 0 : 1);
            }
            if (this.checkHi == 2) {
                this.alarmHi.updateState(this.value <= this.resetHi ? 0 : 1);
            }
        }
        if (ok) {
            cState.set(this.id);
        }
    }

    @ConfigChanger
    public void setLimitLo(double limit) {
        if (!this.valid || limit == this.limitLo) {
            return;
        }
        this.limitLo = limit;
        this.mon.loLimChange.set(this.id);
        this.mon.publishState();
        this.mon.subsys.publishMetaData(this.name, "alarmLow", String.valueOf(limit));
    }

    @ConfigChanger
    public void setLimitHi(double limit) {
        if (!this.valid || limit == this.limitHi) {
            return;
        }
        this.limitHi = limit;
        this.mon.hiLimChange.set(this.id);
        this.mon.publishState();
        this.mon.subsys.publishMetaData(this.name, "alarmHigh", String.valueOf(limit));
    }

    public double getValue() {
        return this.value;
    }
}

