/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class Alarm
extends ConfigurableComponent {
    public static final int EVENT_TRIP = 0;
    public static final int EVENT_LIMBO = 1;
    public static final int EVENT_RESET = 2;
    static final int STATE_GOOD = 0;
    static final int STATE_DEADBAND = 1;
    static final int STATE_ERROR = 2;
    String lineName;
    int eventParm;
    Line line;
    Monitor mon;
    int state;
    int newState;

    public Alarm(String lineName, int eventParm) {
        this.lineName = lineName;
        this.eventParm = eventParm;
    }

    void configure(Monitor mon) {
        this.mon = mon;
        try {
            if (this.lineName != null) {
                this.line = mon.getLine(this.lineName);
                if (this.line == null) {
                    mon.reportError(this.getName(), "line", this.lineName);
                }
            }
        }
        catch (Exception exception) {}
    }

    void initialize() {
        this.state = 0;
        if (this.line != null) {
            this.line.set(false);
        }
    }

    void clearState() {
        this.newState = 0;
    }

    void updateState(int value) {
        if (value > this.newState) {
            this.newState = value;
        }
    }

    void setState() {
        if (this.newState != this.state && (this.newState != 1 || this.state != 0)) {
            Boolean set = null;
            Integer event = null;
            if (this.newState == 2) {
                set = true;
                event = 0;
            } else if (this.state == 2) {
                set = false;
                event = this.newState == 0 ? 2 : 1;
            } else if (this.newState == 0) {
                event = 2;
            }
            if (this.line != null && set != null) {
                this.line.set(set);
            }
            if (this.eventParm >= 0 && event != null) {
                this.mon.alarmH.processAlarm(event, this.eventParm);
            }
            this.state = this.newState;
        }
        this.newState = 0;
    }
}

