package org.lsst.ccs.subsystem.monitor;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.utilities.logging.Logger;

/**
 ******************************************************************************
 **
 **  Implements a control "channel".
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public abstract class Control extends ConfigurableComponent {

   /**
    ***************************************************************************
    **
    **  Data fields.
    **
    ***************************************************************************
    */
    // Supplied immutable fields
    protected String  description;   // Channel description
    protected int     hwChan;        // HW channel number

    // Derived immutable fields
    protected Device  devc;          // Associated device object
    protected Monitor mon;           // Associated monitor object
    protected Logger  log;           // Message logger


   /**
    ***************************************************************************
    **
    **  Constructor.
    **
    ***************************************************************************
    */
    public Control(String desc, int hwChan)
    {
        this.description = desc;
        this.hwChan = hwChan;
    }


   /**
    ***************************************************************************
    **
    **  Configures common part of control channel.
    **
    ***************************************************************************
    */
    protected void configure(Monitor mon, Device devc)
    {
        this.mon = mon;
        this.devc = devc;
        log = mon.log;
    }


   /**
    ***************************************************************************
    **
    **  Gets the channel description.
    **
    ***************************************************************************
    */
    public String getDescription()
    {
        return description;
    }


   /**
    ***************************************************************************
    **
    **  Gets the hardware channel number.
    **
    ***************************************************************************
    */
    public int getHwChan()
    {
        return hwChan;
    }


   /**
    ***************************************************************************
    **
    **  Gets the name-value pair list of configured values.
    **
    ***************************************************************************
    */
    //@BusCommand
    public List getConfigValues()
    {
        List list = new ArrayList();
        addConfigValues(list);

        return list;
    }


   /**
    ***************************************************************************
    **
    **  Adds to a name-value pair list of configured values.
    **
    ***************************************************************************
    */
    public abstract void addConfigValues(List list);

}
