package org.lsst.ccs.subsystem.device;

import org.apache.log4j.Logger;
import org.lsst.ccs.drivers.dmmio.DMMIOBoardDriver;
import org.lsst.ccs.framework.Module;

/**
 * A generic module that gives access to a DMM I/O Board
 * 
 * @author aubourg
 * 
 */

public class DMMIOBoard extends Module {

	private static final long serialVersionUID = 7971960930215405499L;

	DMMIOBoardDriver driver = new DMMIOBoardDriver();

	int baseAddress = 0x300;

	double outAnalog[];

	byte outDigital;

	public int getBaseAddress() {
		return baseAddress;
	}

	public double getGain() {
		return driver.getGain();
	}

	public void setGain(double gain) {
		driver.setGain(gain);
	}

	public void setBaseAddress(int baseAddress) {
		driver.setBaseAddress(baseAddress);
	}

	static Logger log = Logger.getLogger(DMMIOBoard.class);

	boolean inited = false;

	@Override
	public void initModule() {
		driver.setBaseAddress(baseAddress);
		driver.init();
		driver.setGain(2.);
		outAnalog = new double[driver.getAnalogOutChannels()];
		outDigital = 0;
		inited = true;
	}

	public double[] getAnalogInValues() {
		if (!inited) {
			init();
		}
		int nch = driver.getAnalogInChannels();
		driver.setAnalogChannelRange((byte) 0, (byte) (nch - 1));
		double[] v = new double[nch];
		for (int i = 0; i < nch; i++) {
			v[i] = driver.getNextAnalogInChannel();
		}
		return v;
	}

	public double getAnalogInValue(int i) {
		if (!inited) {
			init();
		}
		return driver.getAnalogInChannel(i);
	}

	public byte getDigitalInByte() {
		if (!inited) {
			init();
		}
		return driver.getDigitalInChannelsByte();
	}

	public void setAnalogOutValues(double[] values) {
		if (!inited) {
			init();
		}
		for (int i = 0; i < values.length; i++) {
			driver.setAnalogOutChannel(i, values[i]);
			outAnalog[i] = values[i];
		}
	}

	public void setAnalogOutValue(int i, double value) {
		if (!inited) {
			init();
		}
		outAnalog[i] = value;
		driver.setAnalogOutChannel(i, value);
	}

	public double[] getAnalogOutValues() {
		if (!inited) {
			init();
		}
		double[] v = new double[outAnalog.length];
		System.arraycopy(outAnalog, 0, v, 0, v.length);
		return v;
	}

	public void setDigitalOutByte(byte b) {
		if (!inited) {
			init();
		}
		driver.setDigitalOutChannelsByte(b);
		outDigital = b;
	}

	public byte getDigitalOutByte() {
		if (!inited) {
			init();
		}
		return outDigital;
	}

}
