/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.device;

import org.apache.log4j.Logger;
import org.lsst.ccs.drivers.dmmio.DMMIOBoardDriver;
import org.lsst.ccs.framework.Module;

public class DMMIOBoard
extends Module {
    private static final long serialVersionUID = 7971960930215405499L;
    DMMIOBoardDriver driver = new DMMIOBoardDriver();
    int baseAddress = 768;
    double[] outAnalog;
    byte outDigital;
    static Logger log = Logger.getLogger(DMMIOBoard.class);
    boolean inited = false;

    public int getBaseAddress() {
        return this.baseAddress;
    }

    public double getGain() {
        return this.driver.getGain();
    }

    public void setGain(double gain) {
        this.driver.setGain(gain);
    }

    public void setBaseAddress(int baseAddress) {
        this.driver.setBaseAddress(baseAddress);
    }

    public void initModule() {
        this.driver.setBaseAddress(this.baseAddress);
        this.driver.init();
        this.driver.setGain(2.0);
        this.outAnalog = new double[this.driver.getAnalogOutChannels()];
        this.outDigital = 0;
        this.inited = true;
    }

    public double[] getAnalogInValues() {
        if (!this.inited) {
            this.init();
        }
        int nch = this.driver.getAnalogInChannels();
        this.driver.setAnalogChannelRange((byte)0, (byte)(nch - 1));
        double[] v = new double[nch];
        int i = 0;
        while (i < nch) {
            v[i] = this.driver.getNextAnalogInChannel();
            ++i;
        }
        return v;
    }

    public double getAnalogInValue(int i) {
        if (!this.inited) {
            this.init();
        }
        return this.driver.getAnalogInChannel(i);
    }

    public byte getDigitalInByte() {
        if (!this.inited) {
            this.init();
        }
        return this.driver.getDigitalInChannelsByte();
    }

    public void setAnalogOutValues(double[] values) {
        if (!this.inited) {
            this.init();
        }
        int i = 0;
        while (i < values.length) {
            this.driver.setAnalogOutChannel(i, values[i]);
            this.outAnalog[i] = values[i];
            ++i;
        }
    }

    public void setAnalogOutValue(int i, double value) {
        if (!this.inited) {
            this.init();
        }
        this.outAnalog[i] = value;
        this.driver.setAnalogOutChannel(i, value);
    }

    public double[] getAnalogOutValues() {
        if (!this.inited) {
            this.init();
        }
        double[] v = new double[this.outAnalog.length];
        System.arraycopy(this.outAnalog, 0, v, 0, v.length);
        return v;
    }

    public void setDigitalOutByte(byte b) {
        if (!this.inited) {
            this.init();
        }
        this.driver.setDigitalOutChannelsByte(b);
        this.outDigital = b;
    }

    public byte getDigitalOutByte() {
        if (!this.inited) {
            this.init();
        }
        return this.outDigital;
    }
}

