package org.lsst.ccs.subsystem.common;

import java.util.Observable;

import org.lsst.ccs.framework.Module;

/**
 * A base class for a binary operator.
 * 
 * The two input values are updated through observers The class computes
 * periodically the output value using the current input values
 * 
 * @author aubourg
 * 
 */
public abstract class BinaryOpModule extends Module {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3267922300622901500L;
	String input1;
	String input2;
	String output;

	public String getInput1() {
		return input1;
	}

	/**
	 * The name of input parameter 1, will be checked when update is called.
	 * 
	 * @param input1
	 */

	public void setInput1(String input1) {
		this.input1 = input1;
	}

	public String getInput2() {
		return input2;
	}

	/**
	 * The name of input parameter 2, will be checked when update is called.
	 * 
	 * @param input2
	 */
	public void setInput2(String input2) {
		this.input2 = input2;
	}

	public String getOutput() {
		return output;
	}

	/**
	 * The name used to broadcast the result
	 * 
	 * @param output
	 */
	public void setOutput(String output) {
		this.output = output;
	}

	protected double current1;
	protected double current2;

	/**
	 * Computes the output from the current values of the input parameters. This
	 * method has to be overriden by derived class.
	 * 
	 * @return the result
	 */

	public abstract double op();

	@Override
	public void processUpdate(Observable source, ValueUpdate update) {
		if (update.getName().equals(input1)) {
			current1 = (Double) update.getValue();
		} else if (update.getName().equals(input2)) {
			current2 = (Double) update.getValue();
		}
	}

	@Override
	public void tick() {
		try {
			setChanged();
			notifyObservers(new ValueUpdate(output, op()));
		} catch (Exception e) {
			log.error(e);
		}
	}
}
