package org.lsst.ccs.subsystem.common;

import org.apache.log4j.Logger;

/**
 * Averaging downsampler
 * 
 * @author aubourg
 * 
 */
public class Averager extends UnaryOpModule {
	/**
	 * 
	 */
	private static final long serialVersionUID = -4691173751121943458L;

	public Averager() {
	}

	protected static Logger log = Logger.getLogger("lsst.ccs.modular");

	private long delayMillis = 1000;

	long nextSampleTimestamp = 0;

	double sum;

	int nsamples;

	private double value;

	public void setDelayMillis(long delayMillis) {
		this.delayMillis = delayMillis;
		log.info("Averager delay " + delayMillis);
	}

	public long getDelayMillis() {
		return delayMillis;
	}

	public double getValue() {
		return value;
	}

	public void setValue(double value) {
		this.value = value;
	}

	protected void reset() {
		long now = System.currentTimeMillis();
		if (nextSampleTimestamp == 0) {
			nextSampleTimestamp = now + delayMillis;
		} else {
			do {
				nextSampleTimestamp += delayMillis;
			} while (nextSampleTimestamp <= now);
		}

		sum = 0;
		nsamples = 0;
	}

	int sequenceNumber = 0;

	protected void updateValue(String output) {
		value = sum / nsamples;
		reset();
		log.info(output + " average " + value);
		setChanged();
		notifyObservers(new ValueUpdate(output, value));
	}

	@Override
	public Object processInput(String output, String input, Object val,
			long timeStamp) {
		if (val instanceof Double) {
			if (nextSampleTimestamp == 0) {
				reset();
			}

			sum += (Double) val;
			nsamples++;
			if (System.currentTimeMillis() > nextSampleTimestamp) {
				updateValue(output);
			}
		}
		return null;
	}

}
