/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.proxies;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.proxies.HardwareControlNotReady;
import org.lsst.ccs.utilities.beanutils.WrappedException;
import org.lsst.ccs.utilities.dispatch.ASyncObserver;
import org.lsst.ccs.utilities.dispatch.ParallelObservable;

public class TcpProxy
extends Module {
    private static Logger logger = Logger.getLogger((String)"lsst.ccs.subsystem");
    private int portNumber = 6666;
    private Subsystem subsystem;
    private ServerSocket serverSock;
    private Thread serverThread;
    private volatile boolean stopped;
    private ConcurrentHashMap<String, ClientContext> map = new ConcurrentHashMap();
    private ParallelObservable<ClientContext> observable = new ParallelObservable();

    protected ClientContext getContextFor(String clientName) {
        return this.map.get(clientName);
    }

    public void addObserver(ASyncObserver<ClientContext> observer) {
        this.observable.addObserver(observer);
    }

    public void removeObserver(ASyncObserver<ClientContext> observer) {
        this.observable.removeObserver(observer);
    }

    public void initModule() {
        try {
            this.serverSock = new ServerSocket(this.portNumber);
            logger.trace((Object)("SERVER STARTED :" + this.portNumber));
        }
        catch (IOException e) {
            logger.error((Object)"server not started", (Throwable)e);
            throw new WrappedException((Throwable)e);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (!TcpProxy.this.stopped) {
                    try {
                        Socket sock = TcpProxy.this.serverSock.accept();
                        logger.trace((Object)("accept on " + TcpProxy.this.portNumber));
                        BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"), 256);
                        String nameAndProtocol = reader.readLine();
                        String[] words = nameAndProtocol.split(" ");
                        String name = words[0];
                        ClientContext context = new ClientContext(name, reader, sock.getOutputStream());
                        TcpProxy.this.map.put(name, context);
                        TcpProxy.this.observable.notifyObservers((Object)context);
                        logger.trace((Object)("REGISTERED : " + name));
                    }
                    catch (IOException e) {
                        logger.warn((Object)(" unexpected " + e));
                        if (TcpProxy.this.stopped) continue;
                        logger.error((Object)"server in TcpProxy module : ", (Throwable)e);
                    }
                }
            }
        };
        this.serverThread = new Thread(runnable);
        this.serverThread.start();
    }

    public void stop() {
        this.stopped = true;
        this.serverThread.interrupt();
        Enumeration<ClientContext> enumeration = this.map.elements();
        while (enumeration.hasMoreElements()) {
            ClientContext context = enumeration.nextElement();
            try {
                context.reader.close();
                context.writer.close();
            }
            catch (Exception exception) {
                System.out.println("todo: ");
            }
        }
        try {
            Thread.currentThread().interrupt();
            this.getSubsystem().shutdown();
        }
        catch (Exception exc) {
            logger.error((Object)("todo: change this!!!" + exc));
        }
        Thread.currentThread().interrupt();
        System.exit(0);
    }

    public boolean isReady(String clientName) {
        return this.map.get(clientName) != null;
    }

    public Object call(String clientName, String command) {
        ClientContext context = this.map.get(clientName);
        logger.trace((Object)(" CALL :" + clientName + " " + command));
        if (context == null) {
            throw new HardwareControlNotReady(clientName);
        }
        if (this.stopped) {
            throw new IllegalStateException("textTCP module stopped");
        }
        try {
            command = String.valueOf(command) + "\r\n";
            context.writer.write(command, 0, command.length());
            context.writer.flush();
            String response = context.reader.readLine();
            logger.trace((Object)("received response : " + response));
            return response;
        }
        catch (Exception e) {
            this.map.remove(clientName);
            throw new WrappedException(" --> removed " + clientName, (Throwable)e);
        }
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    protected class ClientContext {
        String clientName;
        BufferedReader reader;
        BufferedWriter writer;
        int token;

        ClientContext(String name, BufferedReader reader, OutputStream os) {
            try {
                this.reader = reader;
                this.writer = new BufferedWriter(new OutputStreamWriter(os, "ISO-8859-1"), 256);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"context not started", (Throwable)e);
                throw new Error(e);
            }
        }
    }
}

