/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import org.lsst.ccs.framework.Module;

public class SignalGenerator
extends Module {
    private static final long serialVersionUID = -7468331402973978441L;
    static long timeOrigin = System.currentTimeMillis();
    SignalType signalType = SignalType.SINE;
    double frequency = 10.0;
    double phase = 0.0;
    double amplitude = 1.0;
    double dc = 0.0;
    String output = "signal";
    long lastTick;

    public SignalGenerator() {
        this.tickMillis = 10;
        this.lastTick = 0L;
    }

    public static long getTimeOrigin() {
        return timeOrigin;
    }

    public void setSignalType(String type) {
        this.signalType = SignalType.valueOf(type);
    }

    public String getSignalType() {
        return this.signalType.toString();
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setPhase(double phase) {
        this.phase = phase;
    }

    public double getPhase() {
        return this.phase;
    }

    public void setAmplitude(double amplitude) {
        this.amplitude = amplitude;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getOutput() {
        return this.output;
    }

    public double getDc() {
        return this.dc;
    }

    public void setDc(double dc) {
        this.dc = dc;
    }

    public void tick() {
        try {
            long ts = System.currentTimeMillis();
            if (ts - this.lastTick <= (long)(this.tickMillis / 5)) {
                return;
            }
            this.lastTick = ts;
            double t = (double)(ts - timeOrigin) / 1000.0;
            double phi = (Math.PI * 2 * t * this.frequency + this.phase) % (Math.PI * 2);
            double x = 0.0;
            switch (this.signalType) {
                case SINE: {
                    x = this.amplitude * Math.sin(phi);
                    break;
                }
                case SQUARE: {
                    x = phi > Math.PI ? -this.amplitude : this.amplitude;
                    break;
                }
                case TRIANGLE: {
                    x = phi > Math.PI ? this.amplitude * (3.0 - 2.0 * phi / Math.PI) : this.amplitude * (2.0 * phi / Math.PI - 1.0);
                }
            }
            this.setChanged();
            this.notifyObservers(new Module.ValueUpdate((Module)this, this.output, (Object)(x += this.dc), ts));
        }
        catch (Exception e) {
            Module.log.error((Object)e);
        }
    }

    static enum SignalType {
        SINE,
        SQUARE,
        TRIANGLE;

    }
}

