/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class Similarity {
    public static int compute(String s1, String s2) {
        int[] cost = new int[s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s2.length(); ++j) {
                if (i == 0) {
                    cost[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = cost[j - 1];
                if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), cost[j]) + 1;
                }
                cost[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            cost[s2.length()] = lastValue;
        }
        return cost[s2.length()];
    }

    public static ArrayList<String> head(String probe, List<String> candidates, int max, int threshold) {
        TreeMap<Integer, LinkedList<String>> mapOut = new TreeMap<Integer, LinkedList<String>>();
        int size = 0;
        HashSet<String> in = new HashSet<String>();
        for (String s : candidates) {
            int score;
            if (in.contains(s) || (score = Similarity.compute(probe, s)) >= threshold) continue;
            LinkedList<String> atScore = (LinkedList<String>)mapOut.get(score);
            if (atScore == null) {
                atScore = new LinkedList<String>();
                mapOut.put(score, atScore);
            }
            atScore.add(s);
            in.add(s);
            if (size == max) {
                LinkedList last = (LinkedList)mapOut.lastEntry().getValue();
                in.remove(last.pollLast());
                if (!last.isEmpty()) continue;
                mapOut.pollLastEntry();
                threshold = (Integer)mapOut.lastKey();
                continue;
            }
            if (++size != max) continue;
            threshold = (Integer)mapOut.lastKey();
        }
        ArrayList<String> out = new ArrayList<String>(size);
        mapOut.values().forEach(list -> out.addAll((Collection<String>)list));
        return out;
    }
}

