package org.lsst.ccs.subsystem.common.devices.vacuum;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Defines a vacuum quality monitor interface.
 *
 *  @author Homer Neal
 */
public interface VQMDevice {

    double  readPressure() throws DriverException;
    
    double  getLastPres();
        
    boolean isVacuumGaugeOn() throws DriverException;
    
    void    setGaugeOn() throws DriverException;
    
    void    setGaugeOff() throws DriverException;

//    void    setRunVac(double vac, int cfgstate);
    
//    double  getRunVac(int cfgstate);

    int     getVacState();
    
    void    setVacState(int istate);
    
//    String  readReport() throws DriverException;
    
//    double[][] readAMU() throws DriverException;
    
    String  getIdent() throws DriverException;
    
    void reconnect() throws DriverException;
    
}
