/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.turbopump;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.HasConfigurationParameterDescription;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.twistorr.TwisTorr;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.alerts.TurboAlerts;
import org.lsst.ccs.subsystem.common.devices.vacuum.states.TurboState;

public class TwisTorrDevice
extends Device
implements HasConfigurationParameterDescription {
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final TwisTorr turbo = new TwisTorr();
    private Integer chanKey;
    private volatile TurboState lastState;
    private Thread openMoment;
    protected volatile TwisTorr.CntlrModels model;
    private static final Logger LOG = Logger.getLogger(TwisTorrDevice.class.getName());
    private static final String autotuneMsg = "autotuning: speed below nominal, Run-up timer (15m to FAIL) started";
    private Boolean OK_TO_OPERATE = true;
    private final SupportedOption forceOption = SupportedOption.getSupportedOption((String)"force");
    @ConfigurationParameter(isFinal=true, units="unitless", description="serial port")
    protected volatile String devcId;
    @ConfigurationParameter(isFinal=true, description="Active-Stop mode <true|false>, req pump stopped", units="unitless")
    protected volatile Boolean activeStopMode;
    @ConfigurationParameter(isFinal=true, description="0 = freq, 1 = power", units="Hz")
    protected volatile Integer analogOutput;
    @ConfigurationParameter(isFinal=true, description="Baudrate, 4=9600 ", units="unitless")
    protected volatile Integer baudRate;
    @ConfigurationParameter(isFinal=true, description="0 = always on,1 = controlled", units="unitless")
    protected volatile Integer extFanConfig;
    @ConfigurationParameter(isFinal=true, description="0,1,2 for Ar/N2/He", units="unitless")
    protected volatile Integer gasType;
    @ConfigurationParameter(isFinal=true, description="true/false for Ar/N2", units="unitless")
    protected volatile Boolean gasTypeArgon;
    @ConfigurationParameter(isFinal=true, description="interlock type ... normally continuous", units="unitless")
    protected volatile Boolean interlockType;
    @ConfigurationParameter(isFinal=true, units="unitless", description="true/false for low/normal speed")
    protected volatile Boolean lowSpeedMode;
    @ConfigurationParameter(isFinal=true, description="max power cutoff (read-only)", units="Watts")
    protected volatile Integer maxpower;
    @ConfigurationParameter(isFinal=true, description="Rotation Freq Low limit", units="Hz")
    protected volatile Integer rotfreqLow;
    @ConfigurationParameter(isFinal=true, description="Rotation Freq Max limit", units="Hz")
    protected volatile Integer rotfreqMax;
    @ConfigurationParameter(isFinal=true, description="Rotation Freq Set limit", units="Hz")
    protected volatile Integer rotfreqSet;
    @ConfigurationParameter(isFinal=true, description="0:freq, 1:current, ...", units="Hz")
    protected volatile Integer setpointType;
    @ConfigurationParameter(isFinal=true, description="Threshold to activate digital outout", units="Hz")
    protected volatile Integer setpointThresh;
    @ConfigurationParameter(isFinal=true, description="delay to activate", units="s")
    protected volatile Integer setpointDelay;
    @ConfigurationParameter(isFinal=true, description="Setpoint value for digital outout", units="Hz")
    protected volatile Integer setpointHyst;
    @ConfigurationParameter(isFinal=true, description="0|1 = active(High|Low)", units="unitless")
    protected volatile Boolean setpointActive;
    @ConfigurationParameter(isFinal=true, description="Soft-Start mode <true|false>, req pump stopped", units="unitless")
    protected volatile Boolean softStartMode;
    @ConfigurationParameter(isFinal=true, description="Read speed after Stop", units="unitless")
    protected volatile Boolean speedReadActivate;
    @ConfigurationParameter(isFinal=true, description="critical value per model", units="unitless")
    protected volatile Boolean ventvalveType;
    @ConfigurationParameter(isFinal=true, description="By-command mode", units="unitless")
    protected volatile Boolean ventvalveByCmnd;
    @ConfigurationParameter(isFinal=true, description="opening delay count", units="0.2s/count")
    protected volatile Integer ventDelay;
    @ConfigurationParameter(isFinal=true, description="opening time, 74,84 models only", units="0.2s/count")
    protected volatile Integer ventOpentime;
    @ConfigurationParameter(isFinal=true, description="water cooling", units="unitless")
    protected volatile Boolean waterCooling;
    private double pulseTime = 0.0;
    private int pulseCnt = 0;

    public void initDevice() {
        this.stateService.registerState(TurboState.class, "Turbo-pump State", (Object)this);
        this.alertService.registerAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path));
        this.alertService.registerAlert(TurboAlerts.VERIFY_FAILED.newAlert(this.path));
        this.chanKey = 0;
        if (this.devcId.equals("")) {
            LOG.log(Level.SEVERE, "{0} configuration parameter devcId is missing", new Object[]{this.name});
            throw new RuntimeException("Fatal configuration error");
        }
    }

    public void verifyTurboSetting(TwisTorr.CmndBool cmnd, Object val) {
        boolean success = false;
        if ((this.model.getModelMask() & cmnd.getModels()) != 0) {
            try {
                Boolean value = this.turbo.readBool(cmnd);
                success = value == (Boolean)val;
                LOG.log(Level.FINE, "success:{0} for value:{1} and val:{2} for cmnd:{3} on model:{4}", new Object[]{success, value, val, cmnd, this.model});
                if (success) {
                    return;
                }
                LOG.log(Level.SEVERE, "Check of {0}:{1} != {2} (config value) on model:{4}", new Object[]{cmnd, val, value, this.model});
                this.alertService.raiseAlert(TurboAlerts.VERIFY_FAILED.newAlert(this.path), AlertState.ALARM, String.format("Check of %s:%s != %s (config value) on model:%s", cmnd, val, value, this.model));
                this.OK_TO_OPERATE = false;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Read of val:{0} for register:{1} of model:{2} failed", new Object[]{val, cmnd, this.model});
                this.alertService.raiseAlert(TurboAlerts.VERIFY_FAILED.newAlert(this.path), AlertState.ALARM, String.format("Read of value:%s for register:%s of model:%s failed", val, cmnd, this.model));
                this.OK_TO_OPERATE = false;
                return;
            }
        } else {
            LOG.log(Level.INFO, "skipping val:{0} check of {1} for model:{2} as unsupported", new Object[]{val, cmnd, this.model});
        }
    }

    public void verifyTurboSetting(TwisTorr.CmndNumeric cmnd, Object val) {
        boolean success = false;
        if ((this.model.getModelMask() & cmnd.getModels()) != 0) {
            try {
                int value = this.turbo.readNumeric(cmnd);
                success = value == (Integer)val;
                LOG.log(Level.FINE, "success:{0} for value:{1} and val:{2} for cmnd:{3} on model:{4}", new Object[]{success, value, val, cmnd, this.model});
                if (success) {
                    return;
                }
                LOG.log(Level.SEVERE, "Check of {0}:{1} != {2} (config value) on model:{4}", new Object[]{cmnd, val, value, this.model});
                this.alertService.raiseAlert(TurboAlerts.VERIFY_FAILED.newAlert(this.path), AlertState.ALARM, String.format("Check of %s:%s != %s (config value) on model:%s", cmnd, val, value, this.model));
                this.OK_TO_OPERATE = false;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Read of value:{0} for register:{1} of model:{2} failed", new Object[]{val, cmnd, this.model});
                this.alertService.raiseAlert(TurboAlerts.VERIFY_FAILED.newAlert(this.path), AlertState.ALARM, String.format("Read of value:%s for register:%s of model:%s failed", val, cmnd, this.model));
                this.OK_TO_OPERATE = false;
                return;
            }
        } else {
            LOG.log(Level.INFO, "skipping val:{0} check of {1} for model:{2} as unsupported", new Object[]{val, cmnd, this.model});
        }
    }

    public void initialize() {
        try {
            this.turbo.open(this.devcId);
            int status = this.turbo.readNumeric(TwisTorr.CmndNumeric.STATUS);
            TurboState state = TurboState.getState((int)status);
            LOG.log(Level.INFO, "Connected to {0} Turbo state = {1}, starting hardware settings", new Object[]{this.fullName, state});
            this.closeVentValve();
            this.verifyTurboSetting(TwisTorr.CmndBool.ACTIVE_STOP_MODE, (Object)this.activeStopMode);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.GAS_TYPE, (Object)this.gasType);
            this.verifyTurboSetting(TwisTorr.CmndBool.GAS_TYPE_ARGON, (Object)this.gasTypeArgon);
            this.verifyTurboSetting(TwisTorr.CmndBool.INTERLOCK_TYPE, (Object)this.interlockType);
            this.verifyTurboSetting(TwisTorr.CmndBool.SPEED_READ_ACTIVATE, (Object)this.speedReadActivate);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.SETPOINT_TYPE, (Object)this.setpointType);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.SETPOINT_THRESH, (Object)this.setpointThresh);
            this.verifyTurboSetting(TwisTorr.CmndBool.SETPOINT_ACTIVE, (Object)this.setpointActive);
            this.verifyTurboSetting(TwisTorr.CmndBool.SOFT_START_MODE, (Object)this.softStartMode);
            this.verifyTurboSetting(TwisTorr.CmndBool.VENTVALVE_TYPE, (Object)this.ventvalveType);
            this.verifyTurboSetting(TwisTorr.CmndBool.VENTVALVE_BY_CMND, (Object)this.ventvalveByCmnd);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.VENT_DELAY, (Object)this.ventDelay);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.VENT_OPENTIME, (Object)this.ventOpentime);
            this.verifyTurboSetting(TwisTorr.CmndBool.LOW_SPEED_MODE, (Object)this.lowSpeedMode);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.SETPOINT_DELAY, (Object)this.setpointDelay);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.SETPOINT_HYST, (Object)this.setpointHyst);
            this.verifyTurboSetting(TwisTorr.CmndBool.WATER_COOLING, (Object)this.waterCooling);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.BAUD_RATE, (Object)this.baudRate);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.ANALOG_OUTPUT, (Object)this.analogOutput);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.ROTFREQ_LOW, (Object)this.rotfreqLow);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.ROTFREQ_SET, (Object)this.rotfreqSet);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.ROTFREQ_MAX, (Object)this.rotfreqMax);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.VENT_DELAY, (Object)this.ventDelay);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.EXT_FAN_CONFIG, (Object)this.extFanConfig);
            this.verifyTurboSetting(TwisTorr.CmndNumeric.MAXPOWER, (Object)this.maxpower);
            this.initSensors();
            this.setOnline(true);
            LOG.log(Level.INFO, "{0} Hardware initialization succeeded", new Object[]{this.name});
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.log(Level.SEVERE, "Error connecting/initializing {0}: {1}, closing", new Object[]{this.fullName, e});
            }
            this.close();
        }
        this.inited = true;
    }

    public void close() {
        try {
            this.turbo.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    @Command(type=Command.CommandType.ACTION, name="startTurboPump", description="Start turbo pump", level=100)
    public void startTurboPump() throws DriverException {
        if (!this.OK_TO_OPERATE.booleanValue()) {
            throw new RuntimeException("Must clear error state to operate turbo.");
        }
        this.turbo.writeBool(TwisTorr.CmndBool.START_STOP, true);
    }

    @Command(type=Command.CommandType.ACTION, name="stopTurboPump", description="Stop turbo pump")
    public void stopTurboPump() throws DriverException {
        this.turbo.writeBool(TwisTorr.CmndBool.START_STOP, false);
    }

    @Command(type=Command.CommandType.ACTION, name="timedPulseVentValve", description="pulse open vent valve (certain models only)")
    public void timedPulseVentValve() throws DriverException {
        if (!this.OK_TO_OPERATE.booleanValue()) {
            throw new RuntimeException("Must clear error state to operate turbo.");
        }
        if (!(this.pulseTime >= 0.0) || this.pulseTime > 0.5) {
            throw new RuntimeException("Period for vent must satisfy 0.0 =< pulseTime < 0.5");
        }
        this.openMoment = new Thread("openMoment"){

            @Override
            public void run() {
                try {
                    TwisTorrDevice.this.openVentValve();
                }
                catch (DriverException ex) {
                    try {
                        TwisTorrDevice.this.closeVentValve();
                        LOG.log(Level.SEVERE, "Closed VentValve due to Driver exception");
                    }
                    catch (DriverException driverException) {
                        // empty catch block
                    }
                    throw new RuntimeException("Driver exception occurred when trying to open the turbo vent valve", ex);
                }
                try {
                    Thread.sleep((long)(TwisTorrDevice.this.pulseTime * 1000.0));
                }
                catch (InterruptedException ex) {
                    try {
                        TwisTorrDevice.this.closeVentValve();
                        LOG.log(Level.SEVERE, "Closed VentValve due to exception during sleep()");
                    }
                    catch (DriverException driverException) {
                        // empty catch block
                    }
                    throw new RuntimeException("Unexpected interrupt while waiting for turbo vent valve openning period to end", ex);
                }
                try {
                    TwisTorrDevice.this.closeVentValve();
                }
                catch (DriverException ex) {
                    throw new RuntimeException("Driver exception occurred when trying to close the turbo vent valve", ex);
                }
            }
        };
        this.openMoment.setDaemon(true);
        this.openMoment.start();
    }

    @Command(type=Command.CommandType.ACTION, name="openVentValve", description="open vent valve (certain models only)", level=100)
    public void openVentValve() throws DriverException {
        Boolean type;
        if (!this.OK_TO_OPERATE.booleanValue()) {
            throw new RuntimeException("Must clear error state to operate turbo.");
        }
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_TYPE.getModels()) != 0 && !(type = Boolean.valueOf(this.turbo.readBool(TwisTorr.CmndBool.VENTVALVE_TYPE))).booleanValue()) {
            throw new RuntimeException("vent valve type (window 140) must be 1");
        }
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_OPEN.getModels()) != 0) {
            this.turbo.writeBool(TwisTorr.CmndBool.VENTVALVE_OPEN, true);
        }
    }

    @Command(type=Command.CommandType.ACTION, name="closeVentValve", description="close vent valve (certain models only)")
    public void closeVentValve() throws DriverException {
        Boolean type;
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_TYPE.getModels()) != 0 && !(type = Boolean.valueOf(this.turbo.readBool(TwisTorr.CmndBool.VENTVALVE_TYPE))).booleanValue()) {
            throw new RuntimeException("vent valve type (window 140) must be 1");
        }
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_OPEN.getModels()) != 0) {
            this.turbo.writeBool(TwisTorr.CmndBool.VENTVALVE_OPEN, false);
        }
    }

    @Command(type=Command.CommandType.QUERY, name="showVentValveStatus", description="show vent valve settings and status (certain models only)")
    public String showVentValveStatus() throws DriverException {
        Boolean type;
        String text = "";
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_TYPE.getModels()) != 0 && !(type = Boolean.valueOf(this.turbo.readBool(TwisTorr.CmndBool.VENTVALVE_TYPE))).booleanValue()) {
            throw new RuntimeException("vent valve type (window 140) must be 1");
        }
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_OPEN.getModels()) != 0) {
            Boolean set = this.turbo.readBool(TwisTorr.CmndBool.VENTVALVE_OPEN);
            text = String.format("VENTVALVE_SETTING (122) = %s", set);
        } else {
            text = "Not implemented for this model";
        }
        return text;
    }

    @Command(type=Command.CommandType.QUERY, name="isVentValveOpen", description="return whether the vent valve is open (certain models only)")
    public Boolean isVentValveOpen() throws DriverException {
        Boolean type;
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_TYPE.getModels()) != 0 && !(type = Boolean.valueOf(this.turbo.readBool(TwisTorr.CmndBool.VENTVALVE_TYPE))).booleanValue()) {
            throw new RuntimeException("vent valve type (window 140) must be 1");
        }
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_OPEN.getModels()) != 0) {
            return this.turbo.readBool(TwisTorr.CmndBool.VENTVALVE_OPEN);
        }
        return null;
    }

    public int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        String subtype = ch.getSubTypeStr();
        String name = ch.getName();
        try {
            switch (type) {
                case "Bool": {
                    TwisTorr.CmndBool.valueOf((String)subtype);
                    break;
                }
                case "Numeric": {
                    TwisTorr.CmndNumeric.valueOf((String)subtype);
                    break;
                }
                case "Alpha": {
                    TwisTorr.CmndAlpha.valueOf((String)subtype);
                    break;
                }
                default: {
                    LOG.log(Level.SEVERE, "Invalid type value ({0}) for {1} channel", new Object[]{type, name});
                    throw new Exception("Invalid channel parameter");
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.SEVERE, "Invalid type value ({0}) for {1} channel", new Object[]{type, name});
            throw new Exception("Invalid channel parameter");
        }
        Object object = this.chanKey;
        this.chanKey = this.chanKey + 1;
        return new int[]{this.chanKey, 0};
    }

    public double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        String itemType = ch.getTypeStr();
        String item = ch.getSubTypeStr();
        try {
            switch (itemType) {
                case "Bool": {
                    if (this.turbo.readBool(TwisTorr.CmndBool.valueOf((String)item))) {
                        value = 1.0;
                        break;
                    }
                    value = 0.0;
                    break;
                }
                case "Numeric": {
                    value = this.turbo.readNumeric(TwisTorr.CmndNumeric.valueOf((String)item));
                    if (!item.equals("STATUS")) break;
                    int status = (int)Math.round(value);
                    TurboState state = TurboState.getState((int)status);
                    if (state == this.lastState) break;
                    this.stateService.updateAgentComponentState((Object)this, new Enum[]{state});
                    if (state == TurboState.AUTOTUNING) {
                        this.alertService.raiseAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path), AlertState.WARNING, autotuneMsg);
                    } else if (this.lastState == TurboState.AUTOTUNING) {
                        this.alertService.raiseAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path), AlertState.NOMINAL, "autotuning exit");
                    }
                    if (state == TurboState.FAIL) {
                        try {
                            String cause = this.getTurboFailCode();
                            LOG.log(Level.INFO, this.name + " TURBO FAILURE, cause(s) = " + cause);
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, this.name + " failed to read error code, " + ex);
                        }
                    }
                    this.lastState = state;
                    break;
                }
                case "Alpha": {
                    this.turbo.readAlpha(TwisTorr.CmndAlpha.valueOf((String)item));
                }
            }
        }
        catch (DriverTimeoutException et) {
            LOG.log(Level.SEVERE, this.name + ": TurboPump timeout reading data " + item + ": " + et);
            this.setOnline(false);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, this.name + ": TurboPump exception reading data " + item + ": " + e);
        }
        return value;
    }

    public String getTurboFailCode() throws DriverException {
        int errcode = this.turbo.readNumeric(TwisTorr.CmndNumeric.ERRCODE);
        return Integer.toString(errcode, 16) + ", " + TwisTorr.decodeError((int)errcode);
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="readTurboStatus", description="Get pump status, including operating modes and failure")
    public TwisTorr.PumpStatus readTurboStatus() throws DriverException {
        int status = this.turbo.readNumeric(TwisTorr.CmndNumeric.STATUS);
        return TwisTorr.PumpStatus.decodeStatus((int)status);
    }

    @Command(type=Command.CommandType.QUERY, name="readTurboFailCode", description="Find reason(s) for failure", level=0)
    public String readTurboFailCode() throws DriverException {
        return this.getTurboFailCode();
    }

    @Command(name="setVentPulseCnt", description="Vent valve-open pulse count")
    public void setVentPulseCnt(int value) {
        this.pulseCnt = value;
    }

    @Command(name="setVentPulseTime", description="Vent valve-open time with time in seconds")
    public void setVentPulseTime(double value) {
        this.pulseTime = value;
    }

    @Command(type=Command.CommandType.QUERY, level=1, name="readTurboLife", description="show TurboPump running-time in hours")
    public String readTurboLife() throws DriverException {
        int life = this.turbo.readNumeric(TwisTorr.CmndNumeric.PUMP_HOURS);
        return Integer.toString(life) + " hours";
    }

    @Command(type=Command.CommandType.QUERY, level=1, name="readAll", description="Read all supported controller settings and data")
    @Option(name="force", description="Read all known registers, regardless of controller model")
    public String readAll(Options options) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        Object table = "Read all turbo-pump settings and data\n\n";
        boolean forceRead = options.hasOption(this.forceOption);
        table = (String)table + String.format("Controller Model Set to: %s", this.model.toString());
        TwisTorr.CmndBool[] cmndB = TwisTorr.CmndBool.values();
        int nB = cmndB.length;
        for (int i = 0; i < nB; ++i) {
            if (!forceRead && (this.model.getModelMask() & cmndB[i].getModels()) == 0) continue;
            table = (String)table + String.format("\n%3s    %-22s", cmndB[i].getWindow(), cmndB[i]);
            try {
                boolean respB = this.turbo.readBool(cmndB[i]);
                table = (String)table + Boolean.toString(respB);
                continue;
            }
            catch (DriverException ex) {
                table = (String)table + ex.getMessage();
            }
        }
        table = (String)table + "\n";
        TwisTorr.CmndNumeric[] cmndN = TwisTorr.CmndNumeric.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            if (!forceRead && (this.model.getModelMask() & cmndN[i].getModels()) == 0) continue;
            table = (String)table + String.format("\n%3s    %-22s", cmndN[i].getWindow(), cmndN[i]);
            try {
                int respN = this.turbo.readNumeric(cmndN[i]);
                table = (String)table + Integer.toString(respN);
                continue;
            }
            catch (DriverException ex) {
                table = (String)table + ex.getMessage();
            }
        }
        table = (String)table + "\n";
        TwisTorr.CmndAlpha[] cmndA = TwisTorr.CmndAlpha.values();
        int nA = cmndA.length;
        for (int i = 0; i < nA; ++i) {
            if (!forceRead && (this.model.getModelMask() & cmndA[i].getModels()) == 0) continue;
            table = (String)table + String.format("\n%3s    %-22s", cmndA[i].getWindow(), cmndA[i]);
            try {
                String respA = this.turbo.readAlpha(cmndA[i]);
                table = (String)table + respA;
                continue;
            }
            catch (DriverException ex) {
                table = (String)table + ex.getMessage();
            }
        }
        table = (String)table + "\n";
        long dt = System.currentTimeMillis() - startTime;
        table = (String)table + String.format("\nreadAll() time: %d\n", dt);
        return table;
    }

    public TurboState getTurboState() {
        return this.lastState;
    }

    @Command(type=Command.CommandType.QUERY, name="getOperationalState", description="returns the OK_TO_OPERATE flag state")
    public Boolean getOperationalState() {
        return this.OK_TO_OPERATE;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="resetOperationalState", description="resets the OK_TO_OPERATE flag")
    public void resetOperationalState() {
        this.OK_TO_OPERATE = true;
    }

    public void setModel(TwisTorr.CntlrModels model) throws DriverException {
        this.model = model;
        LOG.log(Level.SEVERE, "Model set to " + model);
    }
}

