/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;

class BootstrapEnvironmentUtils {
    private static final String sysPropFlag = "system.property.";
    private static final String jvmOptFlag = "system.option.";
    private static final String executeKey = "system.pre-execute";

    BootstrapEnvironmentUtils() {
    }

    public static void main(String[] argv) throws MalformedURLException {
        String arg;
        switch (arg = argv[0]) {
            case "LD_LIBRARY_PATH": {
                System.out.println(BootstrapEnvironmentUtils.getBootstrapLibraryPath(argv));
                break;
            }
            case "JAVA_OPTS": {
                System.out.println(BootstrapEnvironmentUtils.getJavaOpts(argv));
                break;
            }
            case "CLASSPATH": {
                System.out.println(BootstrapEnvironmentUtils.getClasspath(argv));
                break;
            }
            case "ALL_IN_ONE": {
                BootstrapEnvironmentUtils.allInOne(argv, System.out);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Option " + arg);
            }
        }
    }

    private static void allInOne(String[] argv, PrintStream out) throws MalformedURLException {
        Properties p;
        Bootstrap b = BootstrapEnvironmentUtils.createBootstrap(argv);
        out.print("export LD_LIBRARY_PATH=");
        out.println(BootstrapEnvironmentUtils.escape(BootstrapEnvironmentUtils.getLibraryPath()));
        out.print("CLASSPATH=");
        out.println(BootstrapEnvironmentUtils.escape(BootstrapEnvironmentUtils.getClasspath()));
        out.print("BOOTSTRAP_JAVA_OPTS=");
        out.println(BootstrapEnvironmentUtils.escape(BootstrapEnvironmentUtils.getJavaOpts("system")));
        String applicationName = Bootstrap.getBootstrapApplication();
        if (applicationName != null && (p = Bootstrap.getBootstrapApplicationProperties()).containsKey(executeKey)) {
            String value = p.getProperty(executeKey);
            if (!value.startsWith(File.separator)) {
                URL url = BootstrapResourceUtils.getResourceURL(value);
                if (url == null) {
                    throw new IllegalArgumentException("Pre-execute script not found: " + value);
                }
                value = url.getFile();
            }
            out.println("source " + value);
        }
    }

    private static String escape(String output) {
        return "'" + output.replace("'", "''") + "'";
    }

    static String getJavaOpts(String[] argv) {
        return BootstrapEnvironmentUtils.getJavaOpts(argv, "system");
    }

    static String getJavaOpts(String[] argv, String fileName) {
        BootstrapEnvironmentUtils.createBootstrap(argv);
        return BootstrapEnvironmentUtils.getJavaOpts(fileName);
    }

    private static String getJavaOpts(String fileName) throws RuntimeException {
        StringBuilder output = new StringBuilder();
        Properties p = BootstrapResourceUtils.getBootstrapProperties(fileName);
        String applicationName = Bootstrap.getBootstrapApplication();
        p.put("system.property.org.lsst.ccs.application.name", applicationName != null ? applicationName : "");
        Set<Object> keys = BootstrapResourceUtils.getAllKeysInProperties(p);
        if (BootstrapEnvironmentUtils.getJavaMajorVersion() >= 17) {
            keys.add("system.option.-add-opens=java.base/java.util=ALL-UNNAMED");
            keys.add("system.option.-add-opens=java.base/java.time=ALL-UNNAMED");
            keys.add("system.option.-add-opens=java.base/java.lang=ALL-UNNAMED");
        }
        for (Object key : keys) {
            String keyStr = (String)key;
            if (keyStr.startsWith(sysPropFlag)) {
                String sysPropertyForJava = keyStr.replace(sysPropFlag, "");
                String sysPropertyValue = p.getProperty(keyStr);
                if (sysPropertyValue == null || sysPropertyValue.isEmpty()) continue;
                output.append("-D");
                output.append(sysPropertyForJava);
                output.append("=");
                output.append(BootstrapUtils.parseProperty(sysPropertyValue));
                output.append(" ");
                continue;
            }
            if (!keyStr.startsWith(jvmOptFlag)) continue;
            String sysOptionForJava = keyStr.replace(jvmOptFlag, "");
            output.append("-");
            output.append(sysOptionForJava);
            String sysOptionValue = p.getProperty(keyStr);
            if (sysOptionValue != null && !sysOptionValue.isEmpty()) {
                output.append(BootstrapUtils.parseProperty(sysOptionValue));
            }
            output.append(" ");
        }
        return output.toString();
    }

    private static Bootstrap createBootstrap(String[] argv) throws RuntimeException {
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        return b;
    }

    static String getClasspath(String[] argv) {
        BootstrapEnvironmentUtils.createBootstrap(argv);
        return BootstrapEnvironmentUtils.getClasspath();
    }

    private static String getClasspath() throws RuntimeException {
        StringBuilder output = new StringBuilder();
        URLClassLoader loader = Bootstrap.getBootstrapApplicationClassLoader();
        URL[] urls = loader.getURLs();
        try {
            for (URL url : urls) {
                output.append(Paths.get(url.toURI())).append(BootstrapUtils.PATH_SEPARATOR);
            }
        }
        catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
        String ret = output.toString();
        return ret.substring(0, ret.length() - 1);
    }

    static String getBootstrapLibraryPath(String[] argv) {
        BootstrapEnvironmentUtils.createBootstrap(argv);
        return BootstrapEnvironmentUtils.getLibraryPath();
    }

    private static String getLibraryPath() {
        Properties p;
        String additionalLibraryPathProperty;
        String libraryPath = BootstrapUtils.getDistributionJniDirectory() + File.pathSeparator + BootstrapUtils.getDistributionLibDirectory();
        String existingLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (existingLibraryPath != null && !existingLibraryPath.isEmpty()) {
            libraryPath = libraryPath + File.pathSeparator + existingLibraryPath;
        }
        if (!(additionalLibraryPathProperty = (p = BootstrapResourceUtils.getBootstrapProperties("system")).getProperty("org.lsst.ccs.ld.library.path", "")).isEmpty()) {
            List<String> dirs = BootstrapUtils.extractDirectoriesFromPath(BootstrapUtils.getDistributionLibDirectory(), additionalLibraryPathProperty, null, false);
            for (String dir : dirs) {
                libraryPath = libraryPath + File.pathSeparator + dir;
            }
        }
        return libraryPath;
    }

    static int getJavaMajorVersion() {
        String[] versionElements = System.getProperty("java.version").split("\\.");
        int discard = Integer.parseInt(versionElements[0]);
        int version = discard == 1 ? Integer.parseInt(versionElements[1]) : discard;
        return version;
    }
}

