/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.conv;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class TypeUtils {
    public static final String NULL_STR = "_null_";

    public static String stringify(Object obj) {
        if (obj == null) {
            return NULL_STR;
        }
        String res = obj instanceof BigDecimal ? ((BigDecimal)obj).toPlainString() : (obj instanceof Map ? TypeUtils.toMapString((Map)obj) : (obj instanceof List ? TypeUtils.toListString((List)obj) : (obj.getClass().isArray() ? TypeUtils.toArrayString(obj) : (obj instanceof Enum ? ((Enum)obj).name() : String.valueOf(obj)))));
        return res;
    }

    private static String toArrayString(Object obj) {
        StringBuilder builder = new StringBuilder("[");
        int size = Array.getLength(obj);
        for (int ix = 0; ix < size; ++ix) {
            Object item = Array.get(obj, ix);
            if (item instanceof String) {
                builder.append(item);
            } else {
                builder.append(TypeUtils.stringify(item));
            }
            if (ix >= size - 1) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String toListString(List list) {
        StringBuilder builder = new StringBuilder("[");
        int size = list.size();
        for (int ix = 0; ix < size; ++ix) {
            Object item = list.get(ix);
            if (item instanceof String) {
                builder.append(item);
            } else {
                builder.append(TypeUtils.stringify(item));
            }
            if (ix >= size - 1) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String toMapString(Map map) {
        StringBuilder builder = new StringBuilder("[");
        TreeSet<Map.Entry> entries = new TreeSet<Map.Entry>(new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry o1, Map.Entry o2) {
                return String.valueOf(o1.getKey()).compareTo(String.valueOf(o2.getKey()));
            }
        });
        entries.addAll(map.entrySet());
        int size = entries.size();
        int ix = 0;
        for (Map.Entry entry : entries) {
            builder.append(entry.getKey()).append(":");
            Object item = entry.getValue();
            if (item instanceof String) {
                builder.append(item);
            } else {
                builder.append(TypeUtils.stringify(item));
            }
            if (ix < size - 1) {
                builder.append(",");
            }
            ++ix;
        }
        builder.append("]");
        return builder.toString();
    }
}

