/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.dataforth;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20Analog;
import org.lsst.ccs.drivers.dataforth.Maq20AnalogIn;
import org.lsst.ccs.drivers.dataforth.Maq20AnalogOut;
import org.lsst.ccs.drivers.dataforth.Maq20Discrete;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteFreq;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteIn;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteOut;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePWM;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class Maq20Device
extends Device {
    public static final int NUM_CHAN_TC = 8;
    public static final int NUM_CHAN_RTD = 6;
    public static final int NUM_CHAN_IVS = 16;
    public static final int NUM_CHAN_IVD = 8;
    public static final int NUM_CHAN_IVO = 8;
    public static final int NUM_CHAN_DIOL = 5;
    public static final int NUM_CHAN_DIOH = 4;
    public static final int NUM_CHAN_PULSE = 3;
    public static final int NUM_CHAN_PWM = 3;
    public static final int NUM_CHAN_FREQ = 1;
    public static final int NUM_CHAN_DINP = 20;
    public static final int NUM_CHAN_DOUT = 20;
    public static final int CHAN_FREQUENCY = 0;
    public static final int CHAN_PULSE_COUNT = 1;
    public static final int CHAN_PULSE_RPM = 2;
    public static final int CHAN_PWM_PERIOD = 0;
    public static final int CHAN_PWM_LOW1 = 1;
    public static final int CHAN_PWM_LOW2 = 2;
    public static final int DISC_FUNC_NONE = -1;
    public static final int DISC_FUNC_PULSE = 0;
    public static final int DISC_FUNC_PWM = 1;
    public static final int DISC_FUNC_FREQ = 2;
    private static final int CHAN_TYPE_ANAL_IN = 0;
    private static final int CHAN_TYPE_ANAL_OUT = 1;
    private static final int CHAN_TYPE_DISC_IN = 2;
    private static final int CHAN_TYPE_DISC_OUT = 3;
    private static final int CHAN_TYPE_DISC_PULSE = 4;
    private static final int CHAN_TYPE_DISC_PWM = 5;
    private static final int CHAN_TYPE_DISC_FREQ = 6;
    private static final Map<String, Integer> discFuncMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> dummyRangeMap;
    private static final Map<String, Integer> ttcRangeMap;
    private static final Map<String, Integer> jtcRangeMap;
    private static final Map<String, Integer> ktcRangeMap;
    private static final Map<String, Integer> rstcRangeMap;
    private static final Map<String, Integer> rtdRangeMap;
    private static final Map<String, Integer> voltRangeMap;
    private static final Map<String, Integer> mvoltRangeMap;
    private static final Map<String, Integer> ampRangeMap;
    private static final Map<String, Integer> voutRangeMap;
    private static final Map<String, ModuleDef> typeMap;
    private static final List<Maq20.ModuleType> typeList;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, Maq20Control> controlMap = new HashMap<String, Maq20Control>();
    @ConfigurationParameter(category="Device", isFinal=true, units="unitless", description="Maq20 IP address")
    protected volatile String node;
    @ConfigurationParameter(category="Device", maxLength=24, isFinal=true, units="unitless", description="serial numbers of MAQ20 modules")
    protected volatile String[] serials;
    protected String[] modules;
    private static final Logger LOG;
    protected final Maq20 maq = new Maq20();
    private ModuleData[] modData;
    protected final Map<String, Channel> channelMap = new TreeMap<String, Channel>();
    private boolean simulation;

    public void build() {
        this.simulation = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.run.mode", "normal").equals("simulation");
        AgentPeriodicTask pt = new AgentPeriodicTask(this.path + "-check-status", () -> this.checkStatusData()).withPeriod(Duration.ofMillis(10000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "node", "is missing");
        }
        if (this.modules == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "modules", "is missing");
        }
        if (this.serials == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "serials", "is missing");
        }
        if (this.modules.length != this.serials.length) {
            ErrorUtils.reportConfigError(LOG, this.path, "modules and serials", "have different lengths");
        }
        this.modData = new ModuleData[this.modules.length];
        for (int j = 0; j < this.modules.length; ++j) {
            ModuleDef mDef;
            ModuleData mData = null;
            String[] words = this.modules[j].split(":");
            if (words.length >= 1 && words.length <= 3 && (mDef = typeMap.get(words[0].toUpperCase())) != null) {
                mData = new ModuleData();
                mData.serial = this.serials[j];
                mData.modDef = mDef;
                if (mDef.opType == 2) {
                    mData.discFunc[0] = -1;
                    mData.discFunc[1] = -1;
                    for (int k = 0; k < words.length - 1; ++k) {
                        Integer func = discFuncMap.get(words[k + 1].trim().toUpperCase());
                        if (func == null) {
                            mData = null;
                            break;
                        }
                        mData.discFunc[k] = func;
                    }
                } else if (words.length != 1) {
                    mData = null;
                }
            }
            if (mData == null) {
                ErrorUtils.reportConfigError(LOG, this.path, "modules", "has invalid item (" + this.modules[j] + ")");
            }
            this.modData[j] = mData;
        }
        if (this.simulation) {
            Maq20.ModuleType[] modTypes = new Maq20.ModuleType[this.getModuleCount()];
            for (int j = 0; j < modTypes.length; ++j) {
                modTypes[j] = this.getModuleData((int)j).modDef.type;
            }
            this.maq.initSimulation(modTypes, this.serials);
            this.fullName = this.path + " (Simulated Maq20 system)";
        } else {
            this.fullName = this.path + " (Maq20 system with IP: " + this.node + ")";
        }
    }

    protected void initialize() {
        try {
            this.maq.open(Modbus.ConnType.NET, this.node);
            block9: for (ModuleData mData : this.modData) {
                if (mData == null) continue;
                mData.modId = this.maq.getModuleId(mData.serial);
                if (mData.modId <= 0) {
                    LOG.log(Level.SEVERE, "Module with serial number {0} not found", mData.serial);
                    continue;
                }
                Maq20.ModuleType type = this.maq.getModuleType(mData.modId);
                if (type != mData.modDef.type) {
                    LOG.log(Level.SEVERE, "Module with serial number {0} has the wrong type ({1})", new Object[]{mData.serial, type});
                    mData.modId = -1;
                    continue;
                }
                switch (mData.modDef.opType) {
                    case 0: {
                        mData.maqAnaIn = this.maq.getAnalIn(mData.modId);
                        mData.maqAna = mData.maqAnaIn;
                        continue block9;
                    }
                    case 1: {
                        mData.maqAnaOut = this.maq.getAnalOut(mData.modId);
                        mData.maqAna = mData.maqAnaOut;
                        continue block9;
                    }
                    case 2: {
                        mData.maqDisc = this.maq.getDiscrete(mData.modId);
                        mData.maqDiscPulse = this.maq.getDiscPulse(mData.modId);
                        mData.maqDiscPWM = this.maq.getDiscPWM(mData.modId);
                        mData.maqDiscFreq = this.maq.getDiscFreq(mData.modId);
                        continue block9;
                    }
                    case 3: {
                        mData.maqDisc = this.maq.getDiscIn(mData.modId);
                        mData.maqDiscIn = this.maq.getDiscIn(mData.modId);
                        continue block9;
                    }
                    case 4: {
                        mData.maqDisc = this.maq.getDiscOut(mData.modId);
                        mData.maqDiscIn = this.maq.getDiscOut(mData.modId);
                        mData.maqDiscOut = this.maq.getDiscOut(mData.modId);
                    }
                }
            }
            for (Maq20Control ctrl : this.controlMap.values()) {
                ctrl.initialize();
            }
            this.initSensors();
            this.setOutputLines();
            this.furtherInitialization();
            this.setOnline(true);
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
        }
        catch (DriverException | ChannelInitializationRuntimeException e) {
            if (!this.inited) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
            }
            this.close();
        }
        this.inited = true;
    }

    protected void furtherInitialization() throws DriverException {
    }

    protected void close() {
        for (Maq20Control ctrl : this.controlMap.values()) {
            ctrl.close();
        }
        try {
            this.maq.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        for (ModuleData mData : this.modData) {
            if (mData == null) continue;
            mData.maqAna = null;
            mData.maqAnaIn = null;
            mData.maqAnaOut = null;
            mData.maqDisc = null;
            mData.maqDiscFreq = null;
            mData.maqDiscPWM = null;
            mData.maqDiscPulse = null;
        }
    }

    public void setOnline(boolean state) {
        super.setOnline(state);
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int modIx = 0;
        int chanType = -1;
        int funcIx = 0;
        Integer iRange = 0;
        ModuleData mData = null;
        try {
            modIx = Integer.decode(ch.getTypeStr());
            if (modIx >= 0 && modIx < this.modData.length) {
                mData = this.modData[modIx];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String subtype = ch.getSubTypeStr();
        if (mData != null) {
            int hwChan;
            boolean subtypeOK = true;
            int numChan = mData.modDef.numChan;
            if (mData.modDef.opType == 2) {
                if (subtype.isEmpty()) {
                    chanType = 2;
                } else if (subtype.toUpperCase().equals("OUT")) {
                    chanType = 3;
                } else {
                    int n = subtype.equals("0") ? 0 : (funcIx = subtype.equals("1") ? 1 : -1);
                    if (funcIx >= 0) {
                        int discFunc = mData.discFunc[funcIx];
                        if (discFunc == 0) {
                            chanType = 4;
                            numChan = 3;
                        } else if (discFunc == 1) {
                            chanType = 5;
                            numChan = 3;
                        } else if (discFunc == 2) {
                            chanType = 6;
                            numChan = 1;
                        }
                    } else {
                        subtypeOK = false;
                    }
                }
            } else if (mData.modDef.opType == 0) {
                if (subtype == null || subtype.isEmpty()) {
                    LOG.log(Level.INFO, "No subtype (range) specified for {0}: using default", ch.getPath());
                } else {
                    Map<String, Integer> rMap = mData.modDef.rangeMap;
                    iRange = rMap.get(subtype.toUpperCase());
                    subtypeOK = iRange != null;
                }
                chanType = 0;
            } else {
                chanType = 1;
            }
            if (!subtypeOK) {
                ErrorUtils.reportChannelError(LOG, ch.getPath(), "subtype (range)", subtype);
            }
            if ((hwChan = ch.getHwChan()) < 0 || hwChan >= numChan) {
                ErrorUtils.reportChannelError(LOG, ch.getPath(), "hwChan", hwChan);
            }
        }
        if (chanType < 0) {
            ErrorUtils.reportChannelError(LOG, ch.getPath(), "type (index)", ch.getType());
        }
        this.channelMap.put(ch.getPath(), ch);
        return new int[]{funcIx << 16 | chanType << 8 | modIx, iRange};
    }

    protected void initChannel(Channel ch) {
        int type = ch.getType();
        ModuleData mData = this.modData[type & 0xFF];
        try {
            if (mData.modId <= 0) {
                LOG.log(Level.SEVERE, "Channel {0} initialization error: module failed initialization", ch.getPath());
                throw new RuntimeException("Channel " + ch.getPath() + " initialization error: module failed initialization");
            }
            if (type >> 8 == 0) {
                int hwChan = ch.getHwChan();
                mData.maqAnaIn.enable(hwChan, true);
                mData.maqAnaIn.setRange(hwChan, ch.getSubType());
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error initializing channel {0}: {1}", new Object[]{ch.getPath(), e});
            throw new ChannelInitializationRuntimeException(e);
        }
    }

    public void postStart() {
        if (this.simulation) {
            for (String chanPath : this.channelMap.keySet()) {
                try {
                    this.setChannelValue(chanPath, 20.0 + Math.random());
                }
                catch (DriverException driverException) {}
            }
        }
    }

    protected double readChannel(Channel ch) {
        int type = ch.getType();
        int hwChan = ch.getHwChan();
        double value = Double.NaN;
        if (this.isOnline()) {
            int modIx = type & 0xFF;
            ModuleData mData = this.modData[modIx];
            int funcNum = type >> 16;
            try {
                block1 : switch (type >> 8 & 0xFF) {
                    case 0: 
                    case 1: {
                        value = mData.maqAna.readValue(hwChan);
                        break;
                    }
                    case 2: {
                        value = mData.maqDisc.readDiscIn(hwChan);
                        break;
                    }
                    case 3: {
                        value = mData.maqDisc.readDiscOut(hwChan);
                        break;
                    }
                    case 4: {
                        switch (hwChan) {
                            case 0: {
                                value = mData.maqDiscPulse.readFrequency(funcNum);
                                break block1;
                            }
                            case 1: {
                                value = mData.maqDiscPulse.readPulseCount(funcNum);
                                break block1;
                            }
                            case 2: {
                                value = mData.maqDiscPulse.readRPM(funcNum);
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (hwChan) {
                            case 0: {
                                value = mData.maqDiscPWM.getPeriod(funcNum);
                                break block1;
                            }
                            case 1: {
                                value = mData.maqDiscPWM.getLowTime1(funcNum);
                                break block1;
                            }
                            case 2: {
                                value = mData.maqDiscPWM.getLowTime2(funcNum);
                            }
                        }
                        break;
                    }
                    case 6: {
                        value = mData.maqDiscFreq.getFrequency(funcNum);
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0}, module {1} channel: {2}", new Object[]{this.path, modIx, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    public Maq20 getMaq20() {
        return this.maq;
    }

    public int getModuleCount() {
        return this.modData.length;
    }

    public ModuleData getModuleData(int index) {
        return index >= 0 && index < this.modData.length ? this.modData[index] : null;
    }

    private void checkStatusData() {
        if (!this.isOnline()) {
            return;
        }
        if (this.modData == null) {
            return;
        }
        for (ModuleData mData : this.modData) {
            if (mData == null) continue;
            try {
                if (this.maq.getBrownoutFlag(mData.modId) == 0) continue;
                LOG.log(Level.WARNING, "{0} MAQ20 {1} module with serial no. {2} has brownout flag set", new Object[]{this.path, mData.modDef.type, mData.serial});
                this.maq.clearBrownoutFlag(mData.modId);
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Set a simulated channel value")
    public void setChannelValue(@Argument(description="Channel name") String chanName, @Argument(description="Channel value") double value) throws DriverException {
        if (this.simulation) {
            Channel chan = this.channelMap.get(chanName);
            if (chan == null) {
                throw new DriverException("Invalid channel name: " + chanName);
            }
            ModuleData moduleData = this.getModuleData(chan.getType() & 0xFF);
            if (moduleData.modDef.opType == 0) {
                double offset = chan.convertRawValue(0.0);
                double scale = chan.convertRawValue(1.0) - offset;
                this.maq.setSimChannelValue(moduleData.modId, chan.getHwChan(), (value - offset) / scale);
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }

    static {
        discFuncMap.put("", -1);
        discFuncMap.put("PULSE", 0);
        discFuncMap.put("PWM", 1);
        discFuncMap.put("FREQ", 2);
        dummyRangeMap = new HashMap<String, Integer>();
        ttcRangeMap = new HashMap<String, Integer>();
        ttcRangeMap.put("T400", 0);
        ttcRangeMap.put("T220", 1);
        jtcRangeMap = new HashMap<String, Integer>();
        jtcRangeMap.put("J760", 0);
        jtcRangeMap.put("J393", 1);
        jtcRangeMap.put("J199", 2);
        ktcRangeMap = new HashMap<String, Integer>();
        ktcRangeMap.put("K1350", 0);
        ktcRangeMap.put("K651", 1);
        ktcRangeMap.put("K332", 2);
        rstcRangeMap = new HashMap<String, Integer>();
        rstcRangeMap.put("R1750", 0);
        rstcRangeMap.put("R990", 1);
        rstcRangeMap.put("S1750", 2);
        rstcRangeMap.put("S970", 3);
        rtdRangeMap = new HashMap<String, Integer>();
        rtdRangeMap.put("R850", 0);
        rtdRangeMap.put("R200", 1);
        rtdRangeMap.put("R100", 2);
        voltRangeMap = new HashMap<String, Integer>();
        voltRangeMap.put("V60", 0);
        voltRangeMap.put("V40", 1);
        voltRangeMap.put("V20", 2);
        voltRangeMap.put("V10", 3);
        voltRangeMap.put("V5", 4);
        mvoltRangeMap = new HashMap<String, Integer>();
        mvoltRangeMap.put("V2", 0);
        mvoltRangeMap.put("V1", 1);
        mvoltRangeMap.put("MV250", 2);
        mvoltRangeMap.put("MV100", 3);
        mvoltRangeMap.put("MV50", 4);
        ampRangeMap = new HashMap<String, Integer>();
        ampRangeMap.put("MA0_20", 0);
        ampRangeMap.put("MA4_20", 1);
        voutRangeMap = new HashMap<String, Integer>();
        voutRangeMap.put("VPM10", 0);
        voutRangeMap.put("VPM5", 1);
        voutRangeMap.put("VPM2", 2);
        voutRangeMap.put("VP10", 3);
        voutRangeMap.put("VP5", 4);
        voutRangeMap.put("VP2", 5);
        typeMap = new HashMap<String, ModuleDef>();
        typeList = new ArrayList<Maq20.ModuleType>();
        Maq20.ModuleType type = Maq20.ModuleType.JTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, jtcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.KTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, ktcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.TTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, ttcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.RSTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, rstcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.RTD;
        typeMap.put(type.name(), new ModuleDef(type, 6, rtdRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.VD;
        typeMap.put(type.name(), new ModuleDef(type, 8, voltRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.VS;
        typeMap.put(type.name(), new ModuleDef(type, 16, voltRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.VO;
        typeMap.put(type.name(), new ModuleDef(type, 8, voutRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.MVD;
        typeMap.put(type.name(), new ModuleDef(type, 8, mvoltRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.ID;
        typeMap.put(type.name(), new ModuleDef(type, 8, ampRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.IS;
        typeMap.put(type.name(), new ModuleDef(type, 16, ampRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.IO;
        typeMap.put(type.name(), new ModuleDef(type, 8, ampRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DIOH;
        typeMap.put(type.name(), new ModuleDef(type, 4, dummyRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DIOL;
        typeMap.put(type.name(), new ModuleDef(type, 5, dummyRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DINP;
        typeMap.put(type.name(), new ModuleDef(type, 20, dummyRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DOUT;
        typeMap.put(type.name(), new ModuleDef(type, 20, dummyRangeMap, typeList.size()));
        typeList.add(type);
        LOG = Logger.getLogger(Maq20Device.class.getName());
    }

    public static class ModuleData {
        public String serial;
        public int modId;
        public int[] discFunc = new int[2];
        public ModuleDef modDef;
        public Maq20Analog maqAna;
        public Maq20AnalogIn maqAnaIn;
        public Maq20AnalogOut maqAnaOut;
        public Maq20Discrete maqDisc;
        public Maq20DiscreteFreq maqDiscFreq;
        public Maq20DiscretePulse maqDiscPulse;
        public Maq20DiscretePWM maqDiscPWM;
        public Maq20DiscreteIn maqDiscIn;
        public Maq20DiscreteOut maqDiscOut;
    }

    public static class ModuleDef {
        public final Maq20.ModuleType type;
        public final int opType;
        public final int numChan;
        public final Map<String, Integer> rangeMap;
        public final int index;

        ModuleDef(Maq20.ModuleType type, int numChan, Map rangeMap, int index) {
            this.type = type;
            this.opType = Maq20.getModuleOpType((Maq20.ModuleType)type);
            this.numChan = numChan;
            this.rangeMap = rangeMap;
            this.index = index;
        }
    }

    public static interface Maq20Control {
        public void initialize() throws DriverException;

        public void close();
    }

    private class ChannelInitializationRuntimeException
    extends RuntimeException {
        public ChannelInitializationRuntimeException(DriverException ex) {
            super(ex);
        }
    }
}

