/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.config.RemoteFileServer;

public class RemoteDictionaryDAO {
    private static final Logger LOG = Logger.getLogger(RemoteDictionaryDAO.class.getName());
    private final RemoteFileServer remoteFileServer;
    private final Properties p = new Properties();

    public RemoteDictionaryDAO(String descName, String mountPoint) {
        LOG.log(Level.INFO, "Created Remote Dictionary DAO for description {0}", descName);
        this.p.put("cacheFallback", "when_possible");
        this.remoteFileServer = new RemoteFileServer(descName, mountPoint, this.p);
    }

    public byte[] getDictionary(String dictionaryName) throws IOException {
        Path dictionaryPath = this.pathFromFileName(dictionaryName);
        LOG.log(Level.FINE, "Fetching dictionary {0} from remote server.", dictionaryPath);
        try (InputStream is = this.remoteFileServer.getInputStream(dictionaryPath, new OpenOption[]{StandardOpenOption.READ});){
            byte[] byArray;
            int bufLen = 4096;
            byte[] buf = new byte[4096];
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                int readLen;
                while ((readLen = is.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean isDictionaryAvailable(String dictionaryName) {
        Path dictionaryPath = this.pathFromFileName(dictionaryName);
        return this.remoteFileServer.exists(dictionaryPath);
    }

    public void writeDictionaryIfNeeded(String dictionaryName, byte[] dict) throws Exception {
        Path dictionaryPath = this.pathFromFileName(dictionaryName);
        try (OutputStream os = this.remoteFileServer.getOutputStream(dictionaryPath, new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW});){
            LOG.log(Level.FINE, "Writing dictionary {0} to remote server.", dictionaryPath);
            os.write(dict);
        }
        catch (FileAlreadyExistsException ioe) {
            LOG.log(Level.FINE, "Dictionary {0} already exists in remote server.", dictionaryPath);
        }
    }

    private Path pathFromFileName(String fileName) {
        String[] split = fileName.split("/");
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 1; i < split.length; ++i) {
            args.add(split[i]);
        }
        return this.remoteFileServer.getFileSystem().getPath(split[0], args.toArray(new String[0]));
    }
}

