/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.turbopump;

import java.util.logging.Logger;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.config.HasConfigurationParameterDescription;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.alerts.TurboAlerts;
import org.lsst.ccs.subsystem.common.devices.vacuum.states.TurboState;

public class TwisTorr84Device
extends Device
implements HasConfigurationParameterDescription {
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final TwisTorr84 turbo = new TwisTorr84();
    private Integer chanKey;
    private volatile TurboState lastState;
    @ConfigurationParameter(isFinal=true, units="unitless", description="serial port")
    protected volatile String devcId;
    @ConfigurationParameter(isBuild=true, category="build", units="unitless", description="enumerated pump model")
    protected volatile Model model;
    @ConfigurationParameter(isFinal=true, units="unitless", description="true/false for low/normal speed")
    protected volatile Boolean lowSpeedMode;
    @ConfigurationParameter(isFinal=true, description="Soft-Start mode <true|false>, settable only if pump is stopped", units="unitless")
    protected volatile Boolean softStartMode;
    @ConfigurationParameter(isFinal=true, description="Active-Stop mode <true|false>, settable only if pump is stopped", units="unitless")
    protected volatile Boolean activeStopMode;
    @ConfigurationParameter(isFinal=true, description="Setpoint value for digital outout", units="Hz")
    protected volatile Integer setpointValue;
    private static final Logger LOG = Logger.getLogger(TwisTorr84Device.class.getName());
    private static final String autotuneMsg = "AStress due to leak, for-pressure too high, gas flow too high, or turbo damage. Mitigate within 15 min to avoid FAIL state.";
    private static final long READALL_PAUSE = 100L;
    private final boolean waterCooling = false;
    private final boolean interlockType = true;
    private final boolean ventvalveByCmnd = true;
    private final boolean speedReadActivate = true;
    private final int setpointType = 0;
    private final boolean setpointLevel = false;
    private final int ventDelay = 30;
    private final boolean ventvalveType = true;
    private final int rotfreq_set_84 = 1350;
    private final int rotfreq_set_74 = 1167;
    private final int rotfreq_set_304 = 1010;
    private final int rotfreq_set_305 = 1010;
    private final int rotfreq_low_84 = 1100;
    private final int rotfreq_low_74 = 1000;
    private final int rotfreq_low_304 = 900;
    private final int rotfreq_low_305 = 900;
    private int rotfreq_set;
    private int rotfreq_low;
    private final boolean gasType_84 = false;
    private final int gasType_305 = 1;

    public ConfigurationParameterDescription getConfigurationParameterDescription(String parName) {
        ConfigurationParameterDescription cpd = null;
        if (parName.equals("activeStopMode") || parName.equals("waterCooling")) {
            boolean enableParam = this.model != Model.model305;
            cpd = new ConfigurationParameterDescription();
            cpd.withIsEnabled(enableParam);
        }
        return cpd;
    }

    protected void initDevice() {
        this.stateService.registerState(TurboState.class, "Turbo-pump State", (Object)this);
        this.alertService.registerAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path));
        this.chanKey = 0;
        if (this.devcId.equals("")) {
            ErrorUtils.reportConfigError(LOG, this.name, "devcId", "is missing");
        }
        switch (this.model) {
            case model74: {
                this.rotfreq_set = 1167;
                this.rotfreq_low = 1000;
                break;
            }
            case model84: {
                this.rotfreq_set = 1350;
                this.rotfreq_low = 1100;
                break;
            }
            case model304: {
                this.rotfreq_set = 1010;
                this.rotfreq_low = 900;
                break;
            }
            case model305: {
                this.rotfreq_set = 1010;
                this.rotfreq_low = 900;
                break;
            }
            default: {
                ErrorUtils.reportConfigError(LOG, this.name, "model ", "invalid");
            }
        }
    }

    protected void initialize() {
        try {
            this.turbo.open(this.devcId);
            int status = this.turbo.readNumeric(TwisTorr84.CmndNumeric.STATUS);
            TurboState state = TurboState.getState(status);
            LOG.info("\n Connected to " + this.fullName + ", Turbo state = " + state.toString() + ", starting hardware settings");
            if (state != TurboState.STOP) {
                LOG.warning(this.name + " not in STOP state, so a few writes will be ignored, but writeAndVerity accepts value read if it matches requested value");
            }
            this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.LOW_SPEED, this.lowSpeedMode.booleanValue());
            this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.SOFT_START, this.softStartMode.booleanValue());
            this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.INTERLOCK_TYPE, true);
            this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.VENTVALVE_BY_CMND, true);
            this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.SPEED_READ_ACTIVATE, true);
            this.turbo.writeAndVerifyNumeric(TwisTorr84.CmndNumeric.SETPOINT_TYPE, 0);
            this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.SETPOINT_LEVEL, false);
            this.turbo.writeAndVerifyNumeric(TwisTorr84.CmndNumeric.SETPOINT_VALUE, this.setpointValue.intValue());
            this.turbo.writeAndVerifyNumeric(TwisTorr84.CmndNumeric.VENT_DELAY, 30);
            this.turbo.writeAndVerifyNumeric(TwisTorr84.CmndNumeric.ROTFREQ_SET, this.rotfreq_set);
            this.turbo.writeAndVerifyNumeric(TwisTorr84.CmndNumeric.ROTFREQ_LOW, this.rotfreq_low);
            if (this.model == Model.model305) {
                this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.VENTVALVE_TYPE, true);
            } else {
                this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.ACTIVE_STOP, this.activeStopMode.booleanValue());
                this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.WATER_COOLING, false);
            }
            if (this.model == Model.model305 || this.model == Model.model304) {
                this.turbo.writeAndVerifyNumeric(TwisTorr84.CmndNumeric.GAS_TYPE, 1);
            } else {
                this.turbo.writeAndVerifyBool(TwisTorr84.CmndBool.GAS_TYPE_ARGON, false);
            }
            this.initSensors();
            this.setOnline(true);
            LOG.info(this.name + " Hardware initialization succeeded");
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe("Error connecting to or initializaing " + this.fullName + ": " + (Object)((Object)e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.turbo.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    @Command(type=Command.CommandType.ACTION, name="startTurboPump", description="Start turbo pump")
    public void startTurboPump() throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.START_STOP, true);
    }

    @Command(type=Command.CommandType.ACTION, name="stopTurboPump", description="Stop turbo pump")
    public void stopTurboPump() throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.START_STOP, false);
    }

    @Command(type=Command.CommandType.ACTION, name="openVentValve", description="If model305, open vent valve")
    public void openVentValve() throws DriverException {
        if (this.model == Model.model305) {
            boolean type = this.turbo.readBool(TwisTorr84.CmndBool.VENTVALVE_TYPE);
            this.turbo.writeBool(TwisTorr84.CmndBool.VENTVALVE_OPEN, type);
        }
    }

    @Command(type=Command.CommandType.ACTION, name="closeVentValve", description="If model305, close vent valve")
    public void closeVentValve() throws DriverException {
        if (this.model == Model.model305) {
            boolean type = this.turbo.readBool(TwisTorr84.CmndBool.VENTVALVE_TYPE);
            this.turbo.writeBool(TwisTorr84.CmndBool.VENTVALVE_OPEN, !type);
        }
    }

    @Command(type=Command.CommandType.QUERY, name="showVentValveStatus", description="If model305, show vent valve settings and status")
    public String showVentValveStatus() throws DriverException {
        String text = "";
        if (this.model == Model.model305) {
            Boolean type = this.turbo.readBool(TwisTorr84.CmndBool.VENTVALVE_TYPE);
            Boolean open = this.turbo.readBool(TwisTorr84.CmndBool.VENTVALVE_OPEN);
            Boolean status = type != false ? open : open == false;
            String stext = status != false ? "Open" : "Closed";
            text = "VENTVALVE_TYPE (140) = " + type + ",  VENTVALVE_OPEN (122) = " + open + ",  Valve is " + stext;
        } else {
            text = "Implemented only for model 305-FS";
        }
        return text;
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        String subtype = ch.getSubTypeStr();
        String name = ch.getName();
        try {
            switch (type) {
                case "Bool": {
                    TwisTorr84.CmndBool.valueOf((String)subtype);
                    break;
                }
                case "Numeric": {
                    TwisTorr84.CmndNumeric.valueOf((String)subtype);
                    break;
                }
                case "Alpha": {
                    TwisTorr84.CmndAlpha.valueOf((String)subtype);
                    break;
                }
                default: {
                    ErrorUtils.reportChannelError(LOG, name, "type", type);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError(LOG, name, type + " subtype ", subtype);
        }
        Object object = this.chanKey;
        Integer n = this.chanKey = Integer.valueOf(this.chanKey + 1);
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        String itemType = ch.getTypeStr();
        String item = ch.getSubTypeStr();
        try {
            switch (itemType) {
                case "Bool": {
                    if (this.turbo.readBool(TwisTorr84.CmndBool.valueOf((String)item))) {
                        value = 1.0;
                        break;
                    }
                    value = 0.0;
                    break;
                }
                case "Numeric": {
                    value = this.turbo.readNumeric(TwisTorr84.CmndNumeric.valueOf((String)item));
                    if (!item.equals("STATUS")) break;
                    int status = (int)Math.round(value);
                    TurboState state = TurboState.getState(status);
                    if (state == this.lastState) break;
                    this.stateService.updateAgentComponentState((Object)this, new Enum[]{state});
                    if (state == TurboState.AUTOTUNING) {
                        this.alertService.raiseAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path), AlertState.WARNING, autotuneMsg);
                    } else if (this.lastState == TurboState.AUTOTUNING) {
                        this.alertService.raiseAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path), AlertState.NOMINAL, "out of autotuning state");
                    }
                    if (state == TurboState.FAIL) {
                        try {
                            String cause = this.getTurboFailCode();
                            LOG.info(this.name + " TURBO FAILURE, cause(s) = " + cause);
                        }
                        catch (Exception ex) {
                            LOG.severe(this.name + " failed to read error code, " + ex);
                        }
                    }
                    this.lastState = state;
                    break;
                }
                case "Alpha": {
                    this.turbo.readAlpha(TwisTorr84.CmndAlpha.valueOf((String)item));
                }
            }
        }
        catch (DriverTimeoutException et) {
            LOG.severe(this.name + ": TurboPump timeout reading data " + item + ": " + (Object)((Object)et));
            this.setOnline(false);
        }
        catch (DriverException e) {
            LOG.severe(this.name + ": TurboPump exception reading data " + item + ": " + (Object)((Object)e));
        }
        return value;
    }

    private String getTurboFailCode() throws DriverException {
        int errcode = this.turbo.readNumeric(TwisTorr84.CmndNumeric.ERRCODE);
        return Integer.toString(errcode, 16) + ", " + TwisTorr84.decodeError((int)errcode);
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="readTurboStatus", description="Get pump status, including operating modes and failure")
    public TwisTorr84.PumpStatus readTurboStatus() throws DriverException {
        int status = this.turbo.readNumeric(TwisTorr84.CmndNumeric.STATUS);
        return TwisTorr84.PumpStatus.decodeStatus((int)status);
    }

    @Command(type=Command.CommandType.QUERY, name="readTurboFailCode", description="Find reason(s) for failure", level=0)
    public String readTurboFailCode() throws DriverException {
        return this.getTurboFailCode();
    }

    @Command(type=Command.CommandType.QUERY, level=1, name="readTurboLife", description="show TurboPump running-time in hours")
    public String readTurboLife() throws DriverException {
        int life = this.turbo.readNumeric(TwisTorr84.CmndNumeric.PUMP_HOURS);
        return Integer.toString(life) + " hours";
    }

    @Command(type=Command.CommandType.QUERY, level=1, name="readAll", description="Read all TurboPump controller settings and data")
    public String readAll() throws InterruptedException {
        String table = "Read all turbo-pump settings and data\n\n";
        TwisTorr84.CmndBool[] cmndB = TwisTorr84.CmndBool.values();
        int nB = cmndB.length;
        for (int i = 0; i < nB; ++i) {
            Thread.sleep(100L);
            table = table + String.format("\n   %-22s", cmndB[i]);
            try {
                boolean respB = this.turbo.readBool(cmndB[i]);
                table = table + Boolean.toString(respB);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndNumeric[] cmndN = TwisTorr84.CmndNumeric.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", cmndN[i]);
            try {
                int respN = this.turbo.readNumeric(cmndN[i]);
                Thread.sleep(100L);
                table = table + Integer.toString(respN);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndAlpha[] cmndA = TwisTorr84.CmndAlpha.values();
        int nA = cmndA.length;
        for (int i = 0; i < nA; ++i) {
            table = table + String.format("\n   %-22s", cmndA[i]);
            try {
                String respA = this.turbo.readAlpha(cmndA[i]);
                table = table + respA;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        return table;
    }

    public TurboState getTurboState() {
        return this.lastState;
    }

    public static enum Model {
        model74,
        model84,
        model304,
        model305;

    }
}

