package org.lsst.ccs.subsystem.common;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

/**
 * A Class dedicated to calculating the Rebs total power;
 * 
 * @author The LSST CCS Team
 */
public class RebTotalPower extends DerivedChannel {

    private static final Logger LOG = Logger.getLogger(RebTotalPower.class.getName());    

    @LookupField(strategy = LookupField.Strategy.TREE,pathFilter = "(R\\d\\d)/(Reb\\d|Reb[WG])/Power" )
    private List<Channel> rebPowerChannels = new ArrayList<>();
    

    @Override
    public void init() {
        LOG.log(Level.INFO, "Total Power calculation will use the power information from {0} rebs", new Object[]{rebPowerChannels.size()});
    }

    @Override
    public double evaluateDerivedValue() {
        return calculateRebTotalPower();
    }

    double calculateRebTotalPower() {
        double totalPower = 0;
        for ( Channel rebPowerChannel : rebPowerChannels ) {
            double rebPower = rebPowerChannel.getValue();
            if ( !Double.isNaN(rebPower) ) {
                totalPower += rebPower;
            }            
        }
        return totalPower;
    }
    
}
