/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.RemoteFileServer;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;

public class RestFileServerRemoteDAO
implements ConfigurationDAO {
    private static final Logger LOG = Logger.getLogger(RestFileServerRemoteDAO.class.getName());
    private final RemoteFileServer remoteFileServer;

    public RestFileServerRemoteDAO(String descriptionName) {
        this.remoteFileServer = new RemoteFileServer(descriptionName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SingleCategoryTagData loadCategoryTag(SingleCategoryTag singleCategoryTag) throws ConfigurationServiceException {
        LOG.log(Level.INFO, "Rest loadCategoryTag {0}", singleCategoryTag.toString());
        try {
            int actualVersion;
            String requestedVersion = singleCategoryTag.getVersion();
            VersionOpenOption version = this.convertStringVersion(requestedVersion);
            Path path = this.pathFromCategoryTag(singleCategoryTag);
            String warning = "";
            if (version == VersionOpenOption.DEFAULT || version == VersionOpenOption.LATEST) {
                VersionedFileAttributes vfa = Files.readAttributes(path, VersionedFileAttributes.class, new LinkOption[0]);
                if (version == VersionOpenOption.DEFAULT) {
                    actualVersion = vfa.getDefaultVersion();
                    warning = String.format("=%d", actualVersion);
                    if (actualVersion != vfa.getLatestVersion()) {
                        warning = warning + String.format(" NOT LATEST!", vfa.getLatestVersion());
                    }
                } else {
                    actualVersion = vfa.getLatestVersion();
                    warning = String.format("=%d", actualVersion);
                }
                version = VersionOpenOption.of((int)actualVersion);
            } else {
                actualVersion = Integer.parseInt(version.value());
            }
            try (InputStream in = this.remoteFileServer.getInputStream(path, new OpenOption[]{version});){
                LOG.log(Level.INFO, "Loading {0} version {1}{2}", new Object[]{path, requestedVersion, warning});
                SingleCategoryTagData data = new SingleCategoryTagData(new SingleCategoryTag(singleCategoryTag, String.valueOf(actualVersion)));
                data.load(in);
                SingleCategoryTagData singleCategoryTagData = data;
                return singleCategoryTagData;
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, "Did not find {0} version {1}", new Object[]{path, requestedVersion});
                throw new ConfigurationServiceException("Unable to load: " + singleCategoryTag, (Throwable)x);
            }
        }
        catch (IOException x) {
            throw new ConfigurationServiceException("Error reading category tag: " + singleCategoryTag, (Throwable)x);
        }
    }

    public SingleCategoryTag saveCategoryTagData(SingleCategoryTagData singleCategoryTagData) throws ConfigurationServiceException {
        SingleCategoryTag singleCategoryTag = singleCategoryTagData.getSingleCategoryTag();
        try {
            Path path = this.pathFromCategoryTag(singleCategoryTag);
            LOG.log(Level.INFO, "Saving {0}", path);
            try (BufferedWriter writer = this.remoteFileServer.getBufferedWriter(path, new OpenOption[]{VersionOpenOption.LATEST});){
                writer.write(singleCategoryTagData.fullDataString());
            }
            VersionedFileAttributes vfa = Files.readAttributes(path, VersionedFileAttributes.class, new LinkOption[0]);
            return new SingleCategoryTag(singleCategoryTag, String.valueOf(vfa.getLatestVersion()));
        }
        catch (IOException x) {
            throw new ConfigurationServiceException("Error saving category tag: " + singleCategoryTag, (Throwable)x);
        }
    }

    public void close() {
        this.remoteFileServer.close();
    }

    private Path pathFromCategoryTag(SingleCategoryTag singleCategoryTag) {
        String cat = singleCategoryTag.getCategory();
        if (this.isNullOrEmpty(cat)) {
            cat = "emptyCategory";
        }
        String source = singleCategoryTag.getSource();
        String tag = singleCategoryTag.getTag();
        if (this.isNullOrEmpty(tag)) {
            tag = "emptyTag";
        }
        return this.remoteFileServer.getFileSystem().getPath("config", source, cat, tag + ".properties");
    }

    private boolean isNullOrEmpty(String tag) {
        return tag == null || tag.length() == 0;
    }

    private VersionOpenOption convertStringVersion(String version) {
        try {
            if ("d".equals(version)) {
                return VersionOpenOption.DEFAULT;
            }
            return VersionOpenOption.of((String)version);
        }
        catch (IllegalArgumentException x) {
            throw new ConfigurationServiceException("Illegal version: " + version, (Throwable)x);
        }
    }
}

