package org.lsst.ccs.subsystem.common.devices.power.distribution;

/**
 * A PDU outlet.
 * 
 * @author LSST CCS Team
 */
public class PduOutlet {

    private String name;
    private final int index;
    
    public PduOutlet(int index) {
        this.index = index;
        this.name = "Outlet"+index;
    }
    
    public PduOutlet(int index, String name) {
        this(index);
        this.name = name;
    }
    
    @Override
    public String toString() {
        return name+":"+index;
    }

    public String getName() {
        return name;
    }

    public int getIndex() {
        return index;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    
}


