/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.config.CategoryTag;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class LocalConfigurationDAO
implements ConfigurationDAO {
    Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    public static final Comparator<ConfigurationParameterInfo> configurationParameterComparator = new Comparator<ConfigurationParameterInfo>(){

        @Override
        public int compare(ConfigurationParameterInfo o1, ConfigurationParameterInfo o2) {
            String componentName = o1.getComponentName();
            String otherComponentName = o2.getComponentName();
            if (componentName.equals("main") && !otherComponentName.equals("main")) {
                return 1;
            }
            if (otherComponentName.equals("main") && !otherComponentName.equals("main/")) {
                return -1;
            }
            if (componentName.equals(otherComponentName)) {
                return o1.getParameterName().compareTo(o2.getParameterName());
            }
            return componentName.compareTo(otherComponentName);
        }
    };
    private final ConfigurationWriterProvider writerProvider;
    private final String sourceName;
    private static final String[][] TABLE = new String[][]{{"java.lang.Integer", "integer (example : 6)"}, {"java.lang.String", "String"}, {"java.lang.Double", "double (example : 3.0)"}, {"java.lang.Float", "float (example : 3.0)"}, {"java.lang.Boolean", "boolean (example : true)"}, {"[I", "array of integers (example : [1,34,666] )"}, {"[D", "array of doubles (example : [1.0,34.0,666.66] )"}, {"[F", "array of floats (example : [1.0,34.0,666.66] )"}, {"[Ljava.lang.String;", "array of Strings (example : ['hello', 'world'] )"}};

    public LocalConfigurationDAO(String sourceName, ConfigurationService configurationService) {
        this.writerProvider = new ConfigurationWriterProvider(sourceName, configurationService);
        this.sourceName = sourceName;
        this.log.debug((Object)("Created LocalConfigurationDAO for source " + sourceName));
    }

    public static String toPropertyString(ConfigurationParameterInfo parmInfo) {
        String currentValue = parmInfo.getCurrentValue();
        if (currentValue == null) {
            currentValue = "";
        }
        StringBuilder builder = new StringBuilder();
        String pathName = parmInfo.getPathName();
        String propName = new ParameterPath(parmInfo.getComponentName(), parmInfo.getParameterName()).toString();
        propName = propName == null || "".equals(propName.trim()) ? pathName : propName.trim().replaceAll(" ", "\\\\ ");
        builder.append(propName).append(" = ").append(currentValue);
        return builder.toString();
    }

    private static String getTypeInfo(String typeName) {
        String res = typeName;
        for (String[] keyVal : TABLE) {
            if (!keyVal[0].equals(typeName)) continue;
            return keyVal[1];
        }
        return res;
    }

    public ConfigurationView loadConfiguration(ConfigurationDescription configDesc) throws ConfigurationServiceException {
        ConfigurationView res = new ConfigurationView(configDesc);
        this.log.debug((Object)("local loadconfig desc tags " + configDesc.toString()));
        boolean foundConfiguration = false;
        for (String cat : configDesc.getCategoriesSet()) {
            CategoryTag categoryTag = configDesc.getCategoryTag(cat);
            for (String tag : categoryTag.getTags()) {
                Properties configProperties = this.getConfigurationProperties(tag, cat);
                if (configProperties == null) continue;
                for (Map.Entry<Object, Object> prop : configProperties.entrySet()) {
                    String name = (String)prop.getKey();
                    String val = (String)prop.getValue();
                    res.putParameterValue(name, val);
                }
                foundConfiguration = true;
            }
        }
        return foundConfiguration ? res : null;
    }

    public Properties getConfigurationProperties(String tag, String category) throws ConfigurationServiceException {
        try {
            Properties configProps = this.writerProvider.getConfigurationProperties(tag, category);
            this.log.debug((Object)(configProps == null ? "configProps=null" : "configProps " + configProps.toString()));
            if (configProps != null) {
                return configProps;
            }
        }
        catch (IOException ex) {
            throw new ConfigurationServiceException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public ConfigurationView loadGlobalConfiguration(String globalName, int version) {
        try {
            String fullConfigName = this.writerProvider.getNamedConfiguration(globalName);
            if (fullConfigName == null) {
                throw new IllegalArgumentException("no such global configuration name : " + globalName);
            }
            ConfigurationDescription configDesc = new ConfigurationDescription();
            configDesc.parseConfigurationString(fullConfigName.split(","));
            configDesc.setName(globalName, -3);
            return this.loadConfiguration(configDesc);
        }
        catch (IOException ex) {
            throw new ConfigurationServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Set<String> findAvailableConfigurationsForCategory(String category) {
        HashSet<String> merge = new HashSet<String>();
        merge.addAll(this.writerProvider.findMatchingConfigurations(category));
        return merge;
    }

    public boolean isAvailable() {
        return true;
    }

    public ConfigurationDescription registerConfiguration(ConfigurationInfo configInfo) throws ConfigurationServiceException {
        ConfigurationDescription cd = new ConfigurationDescription(configInfo.getCategorySet());
        for (String cat : configInfo.getCategorySet()) {
            String configName = configInfo.getConfigNameForCategory(cat);
            cd.putTagForCategory(cat, configName, configInfo.getConfigVersion(configName));
        }
        return cd;
    }

    public ConfigurationDescription saveChangesForCategoriesAs(ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            if (configDesc.getName() != null) {
                this.writerProvider.setNamedConfiguration(configDesc);
            }
            Map valuesPerCategory = ConfigurationInfo.getParameterInfoGroupByCategory((List)configInfo.getAllParameterInfo());
            for (String category : configDesc.getCategoriesSet()) {
                CategoryTag categoryTag = configDesc.getCategoryTag(category);
                for (String tag : categoryTag.getTags()) {
                    PrintWriter writer = this.writerProvider.getConfigurationWriter(tag, category);
                    TreeSet<ConfigurationParameterInfo> modifiedParameters = new TreeSet<ConfigurationParameterInfo>(configurationParameterComparator);
                    List pars = (List)valuesPerCategory.get(category);
                    if (pars != null) {
                        for (ConfigurationParameterInfo cpi : pars) {
                            if (cpi.isFinal() || cpi.isReadOnly()) continue;
                            modifiedParameters.add(cpi);
                        }
                        for (ConfigurationParameterInfo parameter : modifiedParameters) {
                            writer.println(LocalConfigurationDAO.toPropertyString(parameter));
                        }
                    }
                    writer.flush();
                    writer.close();
                }
            }
        }
        catch (IOException ex) {
            throw new ConfigurationServiceException("could not open file", (Throwable)ex);
        }
        return configDesc;
    }

    public String locateConfigurations(ConfigurationInfo configInfo) {
        StringBuilder sb = new StringBuilder("current existing configurations location :");
        TreeSet categories = new TreeSet(configInfo.getCategorySet());
        for (String cat : categories) {
            String cname = configInfo.getConfigNameForCategory(cat);
            String pathAgent = this.writerProvider.locateConfiguration(cname, cat);
            if (pathAgent == null) continue;
            sb.append("\n").append("\"").append(cat).append("\":\"").append(cname).append("\" found in : ").append(pathAgent);
        }
        return sb.toString();
    }
}

