/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.apcpdu;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.lsst.ccs.drivers.apcpdu.APC7900Series;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class APC7900Sim
extends Session
implements APC7900Series {
    private final List<String> outlets;
    private final List<Integer> offDelays = new ArrayList<Integer>();
    private final List<Integer> onDelays = new ArrayList<Integer>();
    private final List<Boolean> outletState = new ArrayList<Boolean>();
    private final Random r = new Random();

    public APC7900Sim(List<String> outlets) {
        super(1, "APC>", "User Name :", "Password  :", "exit", Ascii.Terminator.CR);
        this.outlets = outlets;
        for (String outlet : outlets) {
            this.offDelays.add(1);
            this.onDelays.add(1);
            this.outletState.add(Boolean.TRUE);
        }
    }

    @Override
    public void open(Session.ConnType connType, String ident, String username, String password) throws DriverException {
    }

    @Override
    public void open(Session.ConnType connType, String ident) throws DriverException {
    }

    @Override
    public void close() throws DriverException {
    }

    @Override
    public String getProductName() throws DriverException {
        return "APC7900Sim";
    }

    @Override
    public String getFWVersion() throws DriverException {
        return "1.0.0";
    }

    @Override
    public int getPhaseCount() throws DriverException {
        return 1;
    }

    @Override
    public int getOutletCount() throws DriverException {
        return this.outlets.size();
    }

    @Override
    public String getOutletName(int outlet) throws DriverException {
        return this.outlets.get(outlet - 1);
    }

    @Override
    public void setOutletName(int outlet, String name) throws DriverException {
        this.outlets.set(outlet - 1, name);
    }

    @Override
    public int getOutletNumber(String outlet) throws DriverException {
        return this.outlets.indexOf(outlet) + 1;
    }

    @Override
    public Map<String, Integer> getOutletNumberMap() throws DriverException {
        LinkedHashMap<String, Integer> numberMap = new LinkedHashMap<String, Integer>();
        int count = 1;
        for (String outlet : this.outlets) {
            numberMap.put(outlet, count);
            ++count;
        }
        return numberMap;
    }

    @Override
    public int getOutletOnDelay(int outlet) throws DriverException {
        return this.onDelays.get(outlet - 1);
    }

    @Override
    public int getOutletOffDelay(int outlet) throws DriverException {
        return this.offDelays.get(outlet - 1);
    }

    @Override
    public int getOutletOnDelay(String outlet) throws DriverException {
        return this.onDelays.get(this.outlets.indexOf(outlet) + 1);
    }

    @Override
    public int getOutletOffDelay(String outlet) throws DriverException {
        return this.offDelays.get(this.outlets.indexOf(outlet) + 1);
    }

    @Override
    public int[] getOutletOnDelays() throws DriverException {
        int[] result = new int[this.getOutletCount()];
        int count = 0;
        for (Integer i : this.onDelays) {
            result[count] = i;
            ++count;
        }
        return result;
    }

    @Override
    public int[] getOutletOffDelays() throws DriverException {
        int[] result = new int[this.getOutletCount()];
        int count = 0;
        for (Integer i : this.offDelays) {
            result[count] = i;
            ++count;
        }
        return result;
    }

    @Override
    public Map<String, Integer> getOutletOnDelayMap() throws DriverException {
        return this.getOutletDelayMap(true);
    }

    @Override
    public Map<String, Integer> getOutletOffDelayMap() throws DriverException {
        return this.getOutletDelayMap(false);
    }

    private Map<String, Integer> getOutletDelayMap(boolean on) throws DriverException {
        LinkedHashMap<String, Integer> delayMap = new LinkedHashMap<String, Integer>();
        int count = 0;
        for (String line : this.outlets) {
            delayMap.put(line, on ? this.onDelays.get(count) : this.offDelays.get(count));
            ++count;
        }
        return delayMap;
    }

    @Override
    public void setOutletOnDelay(int delay, int outlet) throws DriverException {
        this.onDelays.set(outlet - 1, delay);
    }

    @Override
    public void setOutletOffDelay(int delay, int outlet) throws DriverException {
        this.offDelays.set(outlet - 1, delay);
    }

    @Override
    public void setOutletOnDelay(int delay, String outlet) throws DriverException {
        this.onDelays.set(this.outlets.indexOf(outlet), delay);
    }

    @Override
    public void setOutletOffDelay(int delay, String outlet) throws DriverException {
        this.offDelays.set(this.outlets.indexOf(outlet), delay);
    }

    @Override
    public void setOutletOnDelay(int delay, int[] outlets) throws DriverException {
        for (int outlet : outlets) {
            this.onDelays.set(outlet - 1, delay);
        }
    }

    @Override
    public void setOutletOffDelay(int delay, int[] outlets) throws DriverException {
        for (int outlet : outlets) {
            this.offDelays.set(outlet - 1, delay);
        }
    }

    @Override
    public void setOutletOnDelay(int delay, String[] outlets) throws DriverException {
        for (String outlet : outlets) {
            this.onDelays.set(this.outlets.indexOf(outlet), delay);
        }
    }

    @Override
    public void setOutletOffDelay(int delay, String[] outlets) throws DriverException {
        for (String outlet : outlets) {
            this.offDelays.set(this.outlets.indexOf(outlet), delay);
        }
    }

    @Override
    public boolean isOutletOn(int outlet) throws DriverException {
        return this.outletState.get(outlet - 1);
    }

    @Override
    public boolean isOutletOn(String outlet) throws DriverException {
        return this.outletState.get(this.outlets.indexOf(outlet));
    }

    @Override
    public boolean[] getOutletOnStates() throws DriverException {
        boolean[] states = new boolean[this.outletState.size()];
        for (int i = 0; i < this.outletState.size(); ++i) {
            states[i] = this.outletState.get(i);
        }
        return states;
    }

    @Override
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        LinkedHashMap<String, Boolean> stateMap = new LinkedHashMap<String, Boolean>();
        for (int i = 0; i < this.outletState.size(); ++i) {
            stateMap.put(this.outlets.get(i), this.outletState.get(i));
        }
        return stateMap;
    }

    @Override
    public int setOutletOn(int outlet) throws DriverException {
        this.outletState.set(outlet - 1, Boolean.TRUE);
        return 1;
    }

    @Override
    public int setOutletOff(int outlet) throws DriverException {
        this.outletState.set(outlet - 1, Boolean.FALSE);
        return 1;
    }

    @Override
    public int setOutletOn(String outlet) throws DriverException {
        this.outletState.set(this.outlets.indexOf(outlet), Boolean.TRUE);
        return 1;
    }

    @Override
    public int setOutletOff(String outlet) throws DriverException {
        this.outletState.set(this.outlets.indexOf(outlet), Boolean.FALSE);
        return 1;
    }

    @Override
    public int setOutletsOn(int[] outlets) throws DriverException {
        for (int i : outlets) {
            this.outletState.set(i - 1, Boolean.TRUE);
        }
        return outlets.length;
    }

    @Override
    public int setOutletsOff(int[] outlets) throws DriverException {
        for (int i : outlets) {
            this.outletState.set(i - 1, Boolean.FALSE);
        }
        return outlets.length;
    }

    @Override
    public int setOutletsOn(String[] outlets) throws DriverException {
        for (String outlet : outlets) {
            this.outletState.set(this.outlets.indexOf(outlet), Boolean.TRUE);
        }
        return outlets.length;
    }

    @Override
    public int setOutletsOff(String[] outlets) throws DriverException {
        for (String outlet : outlets) {
            this.outletState.set(this.outlets.indexOf(outlet), Boolean.FALSE);
        }
        return outlets.length;
    }

    @Override
    public int delayedOutletOn(int outlet) throws DriverException {
        return this.setOutletOn(outlet);
    }

    @Override
    public int delayedOutletOff(int outlet) throws DriverException {
        return this.setOutletOff(outlet);
    }

    @Override
    public int delayedOutletOn(String outlet) throws DriverException {
        return this.setOutletOn(outlet);
    }

    @Override
    public int delayedOutletOff(String outlet) throws DriverException {
        return this.setOutletOff(outlet);
    }

    @Override
    public int delayedOutletsOn(int[] outlets) throws DriverException {
        return this.setOutletsOn(outlets);
    }

    @Override
    public int delayedOutletsOff(int[] outlets) throws DriverException {
        return this.setOutletsOff(outlets);
    }

    @Override
    public int delayedOutletsOn(String[] outlets) throws DriverException {
        return this.setOutletsOn(outlets);
    }

    @Override
    public int delayedOutletsOff(String[] outlets) throws DriverException {
        return this.setOutletsOff(outlets);
    }

    @Override
    public double[] readCurrent() throws DriverException {
        double[] currents = new double[this.outlets.size()];
        for (int i = 0; i < this.outlets.size(); ++i) {
            currents[i] = this.r.nextDouble() * 2.0;
        }
        return currents;
    }

    @Override
    public double readVA() throws DriverException {
        return 2.0 + this.r.nextDouble() * 2.0;
    }

    @Override
    public double readPower() throws DriverException {
        return 2.0 + this.r.nextDouble() * 2.0;
    }

    @Override
    public double[] readPowers() throws DriverException {
        double[] values = new double[]{this.readPower(), this.readVA()};
        return values;
    }

    @Override
    public synchronized String[] receiveString(String command) throws DriverException {
        return null;
    }
}

