/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.net.SocketException;
import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.ascii.AsciiIOFtdi;
import org.lsst.ccs.drivers.ascii.AsciiIONet;
import org.lsst.ccs.drivers.ascii.AsciiIOSerial;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class Ascii
implements DriverConstants {
    static final int PARITY_NONE = 0;
    static final int PARITY_ODD = 1;
    static final int PARITY_EVEN = 2;
    static final int PARITY_MARK = 3;
    static final int PARITY_SPACE = 4;
    static final int DBITS_EIGHT = 0;
    static final int DBITS_SEVEN = 1;
    static final int SBITS_ONE = 0;
    static final int SBITS_TWO = 1;
    static final int FLOW_NONE = 0;
    static final int FLOW_RTS_CTS = 1;
    static final int FLOW_DTR_DSR = 2;
    static final int FLOW_XON_XOFF = 4;
    private boolean noNet = false;
    private boolean noSerial = false;
    private boolean keepAlive = false;
    private int defaultParm1 = 0;
    private final byte[] readBuff = new byte[4096];
    private DriverConstants.ConnType connType;
    private String connIdent;
    private int connParm1;
    private int connParm2;
    private AsciiIO io;
    private String cmndTerm = "\r\n";
    private byte[] respTerm = new byte[0];
    private int timeout = 1000;
    private int buffIn;
    private int buffOut;
    private boolean multidrop = false;
    private Boolean dropEcho = false;
    private byte[] laBuff;
    private int laPosn = 0;

    public Ascii() {
    }

    @Deprecated
    public Ascii(Option option) {
        this.setOpts(option);
    }

    public void setOptions(Option option) {
        this.setOpts(option);
    }

    private void setOpts(Option option) {
        this.noNet = option == Option.NO_NET;
        this.noSerial = option == Option.NO_SERIAL || option == Option.KEEP_ALIVE_NO_SERIAL;
        this.keepAlive = option == Option.KEEP_ALIVE || option == Option.KEEP_ALIVE_NO_SERIAL;
    }

    public void setDefaultParm(int parm1) {
        this.defaultParm1 = parm1;
    }

    public void setMultidrop() {
        this.multidrop = true;
    }

    public static int makeDataCharacteristics(DataBits dataBits, StopBits stopBits, Parity parity, FlowCtrl flowCtrl) {
        return dataBits.getValue() << 24 | stopBits.getValue() << 16 | parity.getValue() << 8 | flowCtrl.getValue();
    }

    public synchronized void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        AsciiIO newIo;
        if (this.isOpen()) {
            throw new DriverException("Device already connected");
        }
        switch (type) {
            case NET: {
                if (this.noNet) {
                    throw new DriverException("Network connection not allowed");
                }
                newIo = new AsciiIONet();
                break;
            }
            case FTDI: {
                if (this.noSerial) {
                    throw new DriverException("FTDI connection not allowed");
                }
                newIo = new AsciiIOFtdi();
                break;
            }
            case SERIAL: {
                if (this.noSerial) {
                    throw new DriverException("Serial connection not allowed");
                }
                newIo = new AsciiIOSerial();
                break;
            }
            default: {
                throw new DriverException("Connection type not handled: " + type);
            }
        }
        int p1 = parm1 == 0 ? this.defaultParm1 : parm1;
        newIo.open(ident, p1, parm2);
        this.io = newIo;
        this.io.setTimeout(this.timeout);
        this.dropEcho = this.multidrop ? null : Boolean.valueOf(false);
        this.laBuff = null;
        this.connType = type;
        this.connIdent = ident;
        this.connParm1 = p1;
        this.connParm2 = parm2;
    }

    public void open(DriverConstants.ConnType type, String ident, int parm) throws DriverException {
        this.open(type, ident, parm, 0);
    }

    public void open(DriverConstants.ConnType type, String ident) throws DriverException {
        this.open(type, ident, 0);
    }

    public void openNet(String host, int port) throws DriverException {
        this.open(DriverConstants.ConnType.NET, host, port);
    }

    public void openNet(String host) throws DriverException {
        this.openNet(host, 0);
    }

    public void openSerial(String devcName, int baudRate, int dataChar) throws DriverException {
        this.open(DriverConstants.ConnType.SERIAL, devcName, baudRate, dataChar);
    }

    public void openSerial(String devcName, int baudRate) throws DriverException {
        this.openSerial(devcName, baudRate, 0);
    }

    public void openSerial(String devcName) throws DriverException {
        this.openSerial(devcName, 0);
    }

    public void openFtdi(String serialNo, int baudRate, int dataChar) throws DriverException {
        this.open(DriverConstants.ConnType.FTDI, serialNo, baudRate, dataChar);
    }

    public void openFtdi(String serialNo, int baudRate) throws DriverException {
        this.openFtdi(serialNo, baudRate, 0);
    }

    public void openFtdi(String serialNo) throws DriverException {
        this.openFtdi(serialNo, 0);
    }

    public synchronized void close() throws DriverException {
        this.checkOpen();
        try {
            this.io.close();
        }
        finally {
            this.io = null;
            this.buffOut = 0;
            this.buffIn = 0;
        }
    }

    public boolean closeSilent() {
        try {
            this.close();
            return true;
        }
        catch (DriverException e) {
            return false;
        }
    }

    public boolean isOpen() {
        return this.io != null;
    }

    public synchronized void write(String command) throws DriverException {
        this.checkOpen();
        this.writeBytes((command + this.cmndTerm).getBytes());
    }

    public synchronized String read() throws DriverException {
        this.checkOpen();
        StringBuilder sBuff = null;
        int curr = this.buffOut;
        int term = -1;
        while (true) {
            if (curr < this.buffIn) {
                byte buffByte = this.readBuff[curr++];
                if (this.respTerm.length == 0) {
                    if (buffByte != 10 && buffByte != 13) continue;
                    if (curr == this.buffOut + 1) {
                        this.buffOut = curr;
                        continue;
                    }
                    term = curr - 1;
                } else if (term < 0) {
                    if (buffByte != this.respTerm[0]) continue;
                    term = curr - 1;
                    if (this.respTerm.length != 1) {
                        continue;
                    }
                } else if (buffByte != this.respTerm[1]) {
                    term = -1;
                    continue;
                }
                String resp = new String(this.readBuff, this.buffOut, term - this.buffOut);
                this.buffOut = term + this.respTerm.length;
                if (sBuff == null) {
                    return resp;
                }
                return sBuff.append(resp).toString();
            }
            if (this.buffOut > 0) {
                System.arraycopy(this.readBuff, this.buffOut, this.readBuff, 0, this.buffIn - this.buffOut);
                this.buffIn -= this.buffOut;
                term -= this.buffOut;
                this.buffOut = 0;
            }
            if (this.buffIn >= this.readBuff.length) {
                if (sBuff == null) {
                    sBuff = new StringBuilder(new String(this.readBuff, 0, this.buffIn - 1));
                } else {
                    sBuff.append(new String(this.readBuff, 0, this.buffIn - 1));
                }
                this.readBuff[0] = this.readBuff[this.buffIn - 1];
                term -= this.buffIn - 1;
                this.buffIn = 1;
            }
            curr = this.buffIn;
            try {
                this.buffIn += this.readBytes(this.readBuff, this.buffIn);
            }
            catch (DriverTimeoutException re) {
                throw re;
            }
            catch (DriverException re) {
                this.closeSilent();
                throw re;
            }
        }
    }

    public synchronized String read(String command) throws DriverException {
        this.flush();
        this.write(command);
        return this.read();
    }

    public void writeBytes(byte[] command) throws DriverException {
        this.checkOpen();
        this.writeBytes(command, 0, command.length);
    }

    public void writeBytes(byte[] command, int offset, int leng) throws DriverException {
        this.checkOpen();
        try {
            this.io.write(command, offset, leng);
        }
        catch (DriverException e) {
            this.tryReconnect(e);
            this.io.write(command, offset, leng);
        }
        if (this.dropEcho == null) {
            this.dropEcho = this.checkEchoed(command, offset, leng);
        } else if (this.dropEcho.booleanValue()) {
            this.removeEcho(leng);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkEchoed(byte[] command, int offset, int leng) throws DriverException {
        boolean echoed;
        int posn;
        byte[] buff = new byte[leng];
        int tmo = this.timeout;
        this.setTimeout(50);
        try {
            for (posn = 0; posn < leng; posn += this.readBytes(buff, posn)) {
            }
        }
        catch (DriverTimeoutException driverTimeoutException) {
        }
        finally {
            this.setTimeout(tmo);
        }
        if (posn < leng) {
            echoed = false;
        } else {
            echoed = true;
            for (int j = 0; j < leng; ++j) {
                if (buff[j] == command[j + offset]) continue;
                echoed = false;
                break;
            }
        }
        this.laBuff = echoed ? null : buff;
        this.laPosn = 0;
        return echoed;
    }

    private void removeEcho(int leng) throws DriverException {
        byte[] buff = new byte[leng];
        for (int posn = 0; posn < leng; posn += this.readBytes(buff, posn)) {
        }
    }

    public int readBytes(byte[] buff, int offset) throws DriverException {
        this.checkOpen();
        return this.readBytes(buff, offset, buff.length - offset);
    }

    public int readBytes(byte[] buff, int offset, int leng) throws DriverException {
        this.checkOpen();
        int cLeng = 0;
        if (this.laBuff != null) {
            cLeng = Math.min(leng, this.laBuff.length - this.laPosn);
            System.arraycopy(this.laBuff, this.laPosn, buff, offset, cLeng);
            this.laPosn += cLeng;
            if (this.laPosn >= this.laBuff.length) {
                this.laBuff = null;
            }
        }
        try {
            return cLeng + this.io.read(buff, offset + cLeng, leng - cLeng);
        }
        catch (DriverException e) {
            this.tryReconnect(e);
            return cLeng + this.io.read(buff, offset + cLeng, leng - cLeng);
        }
    }

    public synchronized void flush() throws DriverException {
        this.checkOpen();
        this.buffIn = this.buffOut;
        this.io.flush();
    }

    public void setResponseTerm(Terminator term) {
        this.respTerm = term.getValue().getBytes();
    }

    public void setCommandTerm(Terminator term) {
        this.cmndTerm = term.getValue();
    }

    public void setTerminator(Terminator term) {
        this.setCommandTerm(term);
        this.setResponseTerm(term);
    }

    public void setTimeout(double time) throws DriverException {
        this.setTimeout((int)(1000.0 * time));
    }

    public synchronized void setTimeout(int time) throws DriverException {
        this.timeout = time;
        if (this.isOpen()) {
            this.io.setTimeout(this.timeout);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void checkOpen() throws DriverException {
        if (!this.isOpen()) {
            throw new DriverException("Device not connected");
        }
    }

    private void tryReconnect(DriverException e) throws DriverException {
        if (this.keepAlive && e.getCause() instanceof SocketException) {
            this.closeSilent();
            try {
                this.open(this.connType, this.connIdent, this.connParm1, this.connParm2);
            }
            catch (DriverException eo) {
                throw e;
            }
        } else {
            throw e;
        }
    }

    public static enum Terminator {
        CR("\r"),
        LF("\n"),
        CRLF("\r\n");

        String value;

        private Terminator(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }

    public static enum FlowCtrl {
        NONE(0),
        RTS(1),
        DTR(2),
        XON(4),
        RTS_DTR(3),
        RTS_XON(5),
        DTR_XON(6),
        RTS_DTR_XON(7);

        int value;

        private FlowCtrl(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum StopBits {
        ONE(0),
        TWO(1);

        int value;

        private StopBits(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum DataBits {
        SEVEN(1),
        EIGHT(0);

        int value;

        private DataBits(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum Parity {
        NONE(0),
        ODD(1),
        EVEN(2),
        MARK(3),
        SPACE(4);

        int value;

        private Parity(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum Option {
        NO_NET,
        NO_SERIAL,
        KEEP_ALIVE,
        KEEP_ALIVE_NO_SERIAL;

    }
}

