/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.util.zip.GZIPInputStream;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public abstract class BusMessage<T extends Serializable, D>
implements Serializable {
    private static final long serialVersionUID = -51335689636909L;
    private final SerializationUtils<T> serializationUtils = new SerializationUtils();
    private D encodedData;
    private byte[] serializedObject;
    private transient T deserializedObject = null;
    private String className = "";
    private AgentInfo originAgentInfo;
    private volatile transient CCSTimeStamp deserializationTimeStamp;
    private volatile transient CCSTimeStamp doneDeserializationTimeStamp;
    private volatile CCSTimeStamp serializationTimeStamp;
    private volatile transient CCSTimeStamp doneSerializationTimeStamp;
    private final CCSTimeStamp ccsTimeStamp = CCSTimeStamp.currentTime();
    protected final transient T obj;
    private final String compressionProtocol;

    public BusMessage(Class clazz, byte[] ser, String compressionProtocol) {
        this.className = clazz.getName();
        this.encodedData = null;
        this.serializedObject = ser;
        this.obj = null;
        this.compressionProtocol = compressionProtocol;
        if (!compressionProtocol.equals("none") && !compressionProtocol.equals("gzip")) {
            throw new RuntimeException("Unknown compression protocol: " + compressionProtocol);
        }
    }

    public BusMessage(T obj) {
        this.obj = obj;
        if (obj != null) {
            try {
                this.serializedObject = this.serializationUtils.serialize(obj);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not serialize object.", ioe);
            }
            this.encodedData = this.encodeObject(obj);
            this.className = obj.getClass().getName();
        } else {
            this.encodedData = null;
            this.serializedObject = null;
        }
        this.compressionProtocol = "none";
    }

    protected abstract D encodeObject(T var1);

    public String getClassName() {
        return this.className;
    }

    public D getEncodedData() {
        return this.encodedData;
    }

    public T getObject() {
        if (this.obj != null) {
            return this.obj;
        }
        if (this.serializedObject == null) {
            return null;
        }
        if (this.deserializedObject == null) {
            this.deserializedObject = this.serializationUtils.deserialize(this.serializedObject, this.compressionProtocol);
        }
        return this.deserializedObject;
    }

    public AgentInfo getOriginAgentInfo() {
        return this.originAgentInfo;
    }

    public final void setOriginAgentInfo(AgentInfo agent) {
        if (this.originAgentInfo != null) {
            throw new RuntimeException("The setOriginAgentInfo method on BusMessage must be invoked only once!!!");
        }
        this.originAgentInfo = agent;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public String toString() {
        D ed;
        StringBuilder sb = new StringBuilder(1);
        String sOrigin = this.getOriginAgentInfo() != null ? this.getOriginAgentInfo().getName() : "notSet";
        sb.append(this.getClass().getSimpleName()).append(" { origin=").append(sOrigin).append("\n");
        sb.append(" creation timestamp=").append(this.getCCSTimeStamp()).append("\n");
        if (!this.className.isEmpty()) {
            sb.append(" className=").append(this.className).append("\n");
        }
        if ((ed = this.getEncodedData()) != null) {
            sb.append(" encodedData:\n").append(ed).append("\n");
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serializationTimeStamp = CCSTimeStamp.currentTime();
        out.defaultWriteObject();
        out.writeObject(CCSTimeStamp.currentTime());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.deserializationTimeStamp = CCSTimeStamp.currentTime();
        in.defaultReadObject();
        try {
            this.doneSerializationTimeStamp = (CCSTimeStamp)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doneDeserializationTimeStamp = CCSTimeStamp.currentTime();
    }

    public Duration getTransferDuration() {
        if (this.doneSerializationTimeStamp != null && this.deserializationTimeStamp != null) {
            return Duration.between(this.doneSerializationTimeStamp.getUTCInstant(), this.deserializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    public CCSTimeStamp getDoneDeSerializationTime() {
        return this.deserializationTimeStamp;
    }

    public CCSTimeStamp getSerializationTime() {
        return this.serializationTimeStamp;
    }

    public Duration getSerializationDuration() {
        if (this.serializationTimeStamp != null && this.doneSerializationTimeStamp != null) {
            return Duration.between(this.serializationTimeStamp.getUTCInstant(), this.doneSerializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    public Duration getDeserializationDuration() {
        if (this.deserializationTimeStamp != null && this.doneDeserializationTimeStamp != null) {
            return Duration.between(this.deserializationTimeStamp.getUTCInstant(), this.doneDeserializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    private class SerializationUtils<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -1377509787159869583L;

        private SerializationUtils() {
        }

        /*
         * Exception decompiling
         */
        public byte[] serialize(T obj) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T deserialize(byte[] bytes, String compressionProtocol) throws EmbeddedObjectDeserializationException {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
                InputStream is = bis;
                if (compressionProtocol != null && compressionProtocol.equals("gzip")) {
                    is = new GZIPInputStream(is);
                }
                ObjectInputStream ois = new ObjectInputStream(is);
                Serializable result = (Serializable)ois.readObject();
                is.close();
                ois.close();
                Serializable serializable = result;
                return (T)serializable;
            }
            catch (ClassNotFoundException x) {
                throw new EmbeddedObjectDeserializationException("Class not found while deserializing object embedded in message " + this.getClass(), x);
            }
            catch (IOException x) {
                throw new EmbeddedObjectDeserializationException("Could not deserialize object embedded in message " + this.getClass(), x);
            }
        }
    }
}

