/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.structs.ViewValue;

class ConfigurationHandler {
    final Object targetComponent;
    private final String name;
    private final Map<String, ViewValue> submittedChanges = new HashMap<String, ViewValue>();
    private final Map<String, ConfigurationParameterHandler> parameters = new HashMap<String, ConfigurationParameterHandler>();

    ConfigurationHandler(Object target, String name) {
        this.targetComponent = target;
        this.name = name;
    }

    void addParameter(String name, ConfigurationParameterHandler handler) {
        this.parameters.put(name, handler);
    }

    void submitChange(String parameterName, Object value) {
        Object obj = InputConversionEngine.convertArgToType((String)TypeUtils.stringify((Object)value), (Type)this.getConfigurationParameterHandler(parameterName).getType());
        String strValue = TypeUtils.stringify((Object)obj);
        this.submittedChanges.put(parameterName, new ViewValue(strValue, obj));
    }

    void dropSubmittedChanges() {
        this.submittedChanges.clear();
    }

    void invokeValidateBulkChange(boolean isSafe) {
        if (this.submittedChanges.isEmpty()) {
            return;
        }
        this.checkAgainstConstraints(this.submittedChanges, isSafe);
        if (this.targetComponent instanceof ConfigurationBulkChangeHandler) {
            Map<String, ViewValue> currentView = this.convert(this.getCurrentValues(Collections.EMPTY_SET));
            currentView.putAll(this.submittedChanges);
            HashMap<String, Object> toValidate = new HashMap<String, Object>();
            for (Map.Entry<String, ViewValue> entry : currentView.entrySet()) {
                toValidate.put(entry.getKey(), entry.getValue().getValue());
            }
            ((ConfigurationBulkChangeHandler)this.targetComponent).validateBulkChange(toValidate);
        }
    }

    void invokeSetParameters(Map<String, String> before) {
        if (this.targetComponent instanceof ConfigurationBulkChangeHandler && !this.submittedChanges.isEmpty()) {
            ((ConfigurationBulkChangeHandler)this.targetComponent).setParameterBulk(this.submittedChanges.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((ViewValue)entry.getValue()).getValue())));
            for (Map.Entry<String, ViewValue> entry2 : this.submittedChanges.entrySet()) {
                String actualVal;
                String parmName = entry2.getKey();
                String submittedVal = entry2.getValue().getView();
                if (submittedVal.equals(actualVal = this.getConfigurationParameterHandler(parmName).getValue())) continue;
                if (actualVal.equals(before.get(parmName))) {
                    this.getConfigurationParameterHandler(parmName).invokeSetParameter(entry2.getValue().getValue());
                    continue;
                }
                throw new RuntimeException(this.name + "//" + parmName + " value : " + actualVal + ", expected : " + before.get(parmName));
            }
        } else {
            for (String parmName : this.submittedChanges.keySet()) {
                this.getConfigurationParameterHandler(parmName).invokeSetParameter(this.submittedChanges.get(parmName).getValue());
            }
        }
    }

    Collection<ConfigurationParameterHandler> getConfigurationParameterHandlers() {
        return this.parameters.values();
    }

    private void checkAgainstConstraints(Map<String, ViewValue> parms, boolean isSafe) {
        parms.entrySet().stream().forEach(entry -> {
            String parmName = (String)entry.getKey();
            if (!isSafe && this.getConfigurationParameterHandler(parmName).isFinal()) {
                throw new IllegalStateException("Final parameter " + parmName + " not modifiable at runtime");
            }
            Object val = ((ViewValue)entry.getValue()).getValue();
            this.getConfigurationParameterHandler(parmName).checkAgainstConstraints(val);
        });
    }

    private Map<String, ViewValue> convert(Map<ParameterPath, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> this.getConfigurationParameterHandler(((ParameterPath)entry.getKey()).getParameterName()).convert((String)entry.getValue())));
    }

    private static <A, B, C> Function<A, C> compose(Function<A, B> f1, Function<B, C> f2) {
        return f1.andThen(f2);
    }

    Map<String, String> getSubmittedChanges() {
        return Collections.unmodifiableMap(this.submittedChanges.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), ConfigurationHandler.compose(Map.Entry::getValue, ViewValue::getView))));
    }

    Map<ParameterPath, String> getCurrentValues(Set<String> categorySet) {
        HashMap<ParameterPath, String> res = new HashMap<ParameterPath, String>();
        for (ConfigurationParameterHandler cph : this.parameters.values()) {
            if (!categorySet.isEmpty() && !categorySet.contains(cph.getCategory())) continue;
            String strVal = cph.getValue();
            res.put(new ParameterPath(this.name, cph.getParameterName()), strVal);
        }
        return res;
    }

    boolean isParameterConfigurable(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    boolean isParameterReadOnly(String parameterName) {
        ConfigurationParameterHandler cph = this.parameters.get(parameterName);
        return cph == null ? false : cph.isReadOnly();
    }

    boolean isBuildParameter(String parameterName) {
        ConfigurationParameterHandler cph = this.parameters.get(parameterName);
        return cph == null ? false : cph.isBuild();
    }

    boolean isFinalParameter(String parameterName) {
        ConfigurationParameterHandler cph = this.parameters.get(parameterName);
        return cph == null ? false : cph.isFinal();
    }

    private ConfigurationParameterHandler getConfigurationParameterHandler(String parmName) {
        ConfigurationParameterHandler res = this.parameters.get(parmName);
        if (res == null) {
            throw new IllegalArgumentException("no such config property : " + parmName);
        }
        return res;
    }

    void trimSubmittedChanges() {
        Iterator<Map.Entry<String, ViewValue>> it = this.submittedChanges.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ViewValue> entry = it.next();
            if (!this.parameters.get(entry.getKey()).getValue().equals(entry.getValue().getView())) continue;
            it.remove();
        }
    }
}

