/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteFunc;

public class Maq20DiscretePulse
extends Maq20DiscreteFunc {
    private static final short PULSE_COUNT_ADDR = 4;
    private static final short FREQUENCY_ADDR = 6;
    private static final short RPM_ADDR = 8;
    private static final short PULSE_REVN_ADDR = 9;
    private static final short INT_TRIG_ADDR = 10;
    private static final short EXT_ENAB_ADDR = 11;
    private static final short EXT_ENAB_STAT_ADDR = 12;

    public Maq20DiscretePulse(Maq20 maq, int modId) throws DriverException {
        super(maq, modId);
    }

    public void enable(int chan) throws DriverException {
        this.setFunction(chan, 1);
    }

    public boolean isEnabled(int chan) throws DriverException {
        return this.getFunction(chan) == 1;
    }

    public int readPulseCount(int chan) throws DriverException {
        return this.maq.readRegisterPair(this.getRegAddr(chan, 1, 4));
    }

    public void resetPulseCount(int chan) throws DriverException {
        this.maq.writeRegister(this.getRegAddr(chan, 1, 4), (short)0);
    }

    public int readFrequency(int chan) throws DriverException {
        return this.maq.readRegisterPair(this.getRegAddr(chan, 1, 6));
    }

    public int readRPM(int chan) throws DriverException {
        return this.maq.readRegister(this.getRegAddr(chan, 1, 8)) & 0xFFFF;
    }

    public void setPulsesPerRevn(int chan, int count) throws DriverException {
        this.maq.writeRegister(this.getRegAddr(chan, 1, 9), (short)count);
    }

    public int getPulsesPerRevn(int chan) throws DriverException {
        return this.maq.readRegister(this.getRegAddr(chan, 1, 9)) & 0xFFFF;
    }
}

