/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;

public class Maq20Analog {
    public static final int RANGE_TC_T_400 = 0;
    public static final int RANGE_TC_T_220 = 1;
    public static final int RANGE_TC_J_760 = 0;
    public static final int RANGE_TC_J_393 = 1;
    public static final int RANGE_TC_J_199 = 2;
    public static final int RANGE_TC_K_1350 = 0;
    public static final int RANGE_TC_K_651 = 1;
    public static final int RANGE_TC_K_332 = 2;
    public static final int RANGE_TC_R_1750 = 0;
    public static final int RANGE_TC_R_990 = 1;
    public static final int RANGE_TC_S_1750 = 2;
    public static final int RANGE_TC_S_970 = 3;
    public static final int RANGE_RTD_850 = 0;
    public static final int RANGE_RTD_200 = 1;
    public static final int RANGE_RTD_100 = 2;
    public static final int RANGE_VOLT_60 = 0;
    public static final int RANGE_VOLT_40 = 1;
    public static final int RANGE_VOLT_20 = 2;
    public static final int RANGE_VOLT_10 = 3;
    public static final int RANGE_VOLT_5 = 4;
    public static final int RANGE_MVOLT_2000 = 0;
    public static final int RANGE_MVOLT_1000 = 1;
    public static final int RANGE_MVOLT_250 = 2;
    public static final int RANGE_MVOLT_100 = 3;
    public static final int RANGE_MVOLT_50 = 4;
    public static final int RANGE_MAMP_0_20 = 0;
    public static final int RANGE_MAMP_4_20 = 1;
    public static final int RANGE_VOUT_PM10 = 0;
    public static final int RANGE_VOUT_PM5 = 1;
    public static final int RANGE_VOUT_PM2 = 2;
    public static final int RANGE_VOUT_P10 = 3;
    public static final int RANGE_VOUT_P5 = 4;
    public static final int RANGE_VOUT_P2 = 5;
    static final short CHAN_WEIGHT_ADDR = 120;
    static final short CHAN_ENABLE_ADDR = 140;
    static final short CHAN_DATA_ADDR = 1000;
    final Maq20 maq;
    final Maq20.ModuleData module;
    private static final short INVALID_LIMIT = 6000;

    public Maq20Analog(Maq20 maq, int modId) throws DriverException {
        this.maq = maq;
        this.module = maq.getModuleData(modId, false);
        if (this.module.opType != 0 && this.module.opType != 1) {
            throw new DriverException("Invalid module type (" + (Object)((Object)this.module.type) + ") for analog operations");
        }
    }

    public int getNumRanges() {
        return this.module.offset.length;
    }

    public int getRange(int chan) throws DriverException {
        this.checkChannel(chan);
        return this.module.range[chan];
    }

    public void setRange(int chan, int range) throws DriverException {
        this.checkChannel(chan);
        if (range < 0 || range >= this.module.offset.length) {
            throw new DriverException("Invalid range value");
        }
        this.maq.writeRegister((short)(this.module.baseAddr + 100 + chan), (short)range);
        this.module.range[chan] = range;
    }

    public double[] readValue(int chan, int count) throws DriverException {
        int nChan = count >= 0 ? count : this.module.numOutChan + this.module.numInChan - chan;
        this.checkChannel(chan, nChan);
        if (nChan == 0) {
            return new double[0];
        }
        short[] raw = this.maq.readRegisters((short)(this.module.baseAddr + 1000 + chan), (short)nChan);
        double[] data = new double[nChan];
        int j = 0;
        while (j < nChan) {
            if (raw[j] <= -6000 || raw[j] >= 6000) {
                data[j] = Double.NaN;
            } else {
                int range = this.module.range[chan];
                data[j] = this.module.scale[range] * (double)raw[j] - this.module.offset[range];
            }
            ++j;
            ++chan;
        }
        return data;
    }

    public double readValue(int chan) throws DriverException {
        return this.readValue(chan, 1)[0];
    }

    public double[] readValue() throws DriverException {
        return this.readValue(0, -1);
    }

    void checkChannel(int chan) throws DriverException {
        this.checkChannel(chan, 1);
    }

    void checkChannel(int chan, int count) throws DriverException {
        int numChan = this.module.numOutChan + this.module.numInChan;
        if (chan < 0 || chan >= numChan) {
            throw new DriverException("Invalid channel number");
        }
        if (count < 0 || chan + count > numChan) {
            throw new DriverException("Invalid channel count");
        }
    }
}

