/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;

public class Maq20Control
implements HasLifecycle {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Maq20Device maqDevc;
    private String type;
    private static final Logger LOG = Logger.getLogger(Maq20Control.class.getName());
    private Maq20Device.ModuleData modData;
    private boolean haveError = false;

    public void init() {
        String[] words;
        if (this.type == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "type", "not specified");
        }
        if ((words = this.type.split(":")).length != 1) {
            ErrorUtils.reportConfigError(LOG, this.name, "type", "doesn't have exactly one element");
        }
        try {
            int modIx = Integer.decode(words[0]);
            this.modData = this.maqDevc.getModuleData(modIx);
            if (this.modData == null) {
                ErrorUtils.reportConfigError(LOG, this.name, "module " + modIx, "doesn't exist");
            }
        }
        catch (NumberFormatException ex) {
            ErrorUtils.reportConfigError(LOG, this.name, "module index (" + words[0] + ")", "is not numeric");
        }
    }

    public void setLineOn(int chan, boolean on) throws DriverException {
        if (this.modData.maqDisc == null) {
            throw new DriverException("Error setting line: device " + this.maqDevc.getName() + " is offline");
        }
        this.modData.maqDisc.writeDisc(chan, on ? 0 : 1);
    }

    public Boolean isLineOn(int chan) {
        Boolean on;
        block3: {
            on = null;
            try {
                if (this.modData.maqDisc == null) {
                    throw new DriverException(this.maqDevc.getName() + " is offline");
                }
                on = this.modData.maqDisc.readDiscOut(chan) == 0;
                this.haveError = false;
            }
            catch (DriverException e) {
                if (this.haveError) break block3;
                LOG.log(Level.SEVERE, "Error reading channel {0} state: {1}", new Object[]{chan, e});
                this.haveError = true;
            }
        }
        return on;
    }
}

