/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.power.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.apcpdu.APC7900;
import org.lsst.ccs.drivers.apcpdu.APC7900B;
import org.lsst.ccs.drivers.apcpdu.APC7900Series;
import org.lsst.ccs.drivers.apcpdu.APC7900Sim;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.devices.power.distribution.PduOutlet;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduOutletState;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduState;
import org.lsst.ccs.utilities.logging.Logger;

public class APC7900Device
extends Device
implements StateChangeListener {
    public static final int TYPE_POWER = 1;
    public static final int CHAN_CURRENT = 0;
    public static final int CHAN_POWER = 1;
    static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(isFinal=true)
    private String type = "APC7900";
    @ConfigurationParameter(isFinal=true)
    protected String node;
    @ConfigurationParameter(isFinal=true)
    protected int numberOfOutlets = 8;
    @ConfigurationParameter(isFinal=true)
    protected List<String> outlets = new ArrayList<String>();
    private final List<PduOutlet> listOfOutlets = new ArrayList<PduOutlet>();
    protected Map<String, PduOutlet> mapOfOutlets = new HashMap<String, PduOutlet>();
    String user = "apc";
    String passwd = "apc";
    protected final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private APC7900Series pdu;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Agent a;
    private ComponentLookup componentLookup;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupPath
    private String path;

    public void build() {
        super.build();
        if (!this.outlets.isEmpty() && this.outlets.size() != this.numberOfOutlets) {
            throw new IllegalArgumentException("The size of the provided outlets (" + this.outlets.size() + ") must match the provided numberOfOutlets " + this.numberOfOutlets);
        }
        this.componentLookup = this.a.getComponentLookup();
        ComponentNode thisNode = this.componentLookup.getComponentNodeForObject((Object)this);
        for (int i = 1; i <= this.numberOfOutlets; ++i) {
            PduOutlet outlet = new PduOutlet(i);
            if (!this.outlets.isEmpty()) {
                outlet.setName(this.outlets.get(i - 1));
            }
            this.mapOfOutlets.put(outlet.getName(), outlet);
            this.listOfOutlets.add(outlet);
            this.componentLookup.addComponentNodeToLookup(thisNode, new ComponentNode(thisNode, outlet.getName(), (Object)outlet));
        }
        this.a.setAgentProperty("HasPdu", "true");
        String components = this.a.getAgentProperty("Pdu_Components");
        if (components == null) {
            components = "";
        }
        if (!components.isEmpty()) {
            components = components + ",";
        }
        components = components + this.path;
        this.a.setAgentProperty("Pdu_Components", components);
    }

    public void init() {
        if (this.type == "APC7900") {
            this.pdu = new APC7900();
        } else if (this.type == "APC7900B") {
            this.pdu = new APC7900B();
        } else if (this.type == "APC7900Sim") {
            this.pdu = new APC7900Sim(this.outlets);
        }
        this.stateService.registerState(PduState.class, "The state of the Pdu", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{PduState.NOTCONFIGURED});
        for (PduOutlet outlet : this.mapOfOutlets.values()) {
            this.stateService.registerState(PduOutletState.class, "The state of a Pdu Outlet: ON/OFF", (Object)outlet);
        }
        this.stateService.addStateChangeListener((StateChangeListener)this, new Class[]{PduOutletState.class, PduState.class});
        super.init();
    }

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"node", (String)"is not specified");
        }
        this.fullName = "APC7900 PDU (" + this.node + ")";
    }

    protected void initialize() {
        try {
            this.pdu.open(Session.ConnType.TELNET, this.node, this.user, this.passwd);
            Map outNumMap = this.pdu.getOutletNumberMap();
            if (outNumMap.size() != this.numberOfOutlets) {
                throw new RuntimeException("Unexpected number of outlets: " + outNumMap.size() + " it should have been " + this.numberOfOutlets + ".");
            }
            for (String outletName : outNumMap.keySet()) {
                int index = (Integer)outNumMap.get(outletName);
                if (this.outlets.isEmpty()) {
                    this.listOfOutlets.get(index - 1).setName(outletName);
                    continue;
                }
                String providedOutletName = this.outlets.get(index - 1);
                if (outletName.equals(providedOutletName)) continue;
                this.log.warning((Object)("Changing the description for outlet " + index + " from " + outletName + " to " + providedOutletName));
                this.pdu.setOutletName(index, providedOutletName);
            }
            this.initSensors();
            this.setOnline(true);
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{PduState.OK});
            this.sLog.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.sLog.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.pdu.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{PduState.NOTCONFIGURED});
    }

    public void stateChanged(Object changedObj, Enum newState, Enum oldState) {
        if (changedObj instanceof PduOutlet && newState == PduOutletState.OFF) {
            PduOutlet outlet = (PduOutlet)changedObj;
            this.alertService.raiseAlert(new Alert("Pdu_Outlet_Alert", "Outlet turned off"), AlertState.ALARM, "Outlet " + outlet.getName() + " has been turned off");
        }
        if (changedObj == this && newState != PduState.OK) {
            this.alertService.raiseAlert(new Alert("Pdu_Alert", "PDU problem"), AlertState.ALARM, "PDU " + this.getName() + " is in state " + newState);
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        int index = 0;
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"channel type", (Object)type);
        }
        if (hwChan != 0 && hwChan != 1) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{iType | index << 16, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = 0.0;
        switch (type & 0xFFFF) {
            case 1: {
                try {
                    value = hwChan == 1 ? this.pdu.readPower() : this.pdu.readCurrent()[0];
                    break;
                }
                catch (DriverException e) {
                    this.sLog.error((Object)("Error reading power/current value: " + (Object)((Object)e)));
                    this.setOnline(false);
                }
            }
        }
        return value;
    }

    protected void readChannelGroup() {
        for (PduOutlet outlet : this.mapOfOutlets.values()) {
            try {
                double value = this.pdu.isOutletOn(outlet.getIndex()) ? 1.0 : 0.0;
                this.stateService.updateAgentComponentState((Object)outlet, new Enum[]{value == 1.0 ? PduOutletState.ON : PduOutletState.OFF});
            }
            catch (DriverException driverException) {}
        }
    }

    @Command(name="disable", description="Disable the connection to the PDU")
    public void disable() {
        super.disable();
        this.setOnline(false);
    }

    @Command(name="enable", description="Enable the connection to the PDU")
    public void enable() {
        super.enable();
    }

    @Command(name="getOutletNames", description="Get the list of outlet names")
    public List<String> getOutletNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (PduOutlet outlet : this.listOfOutlets) {
            result.add(outlet.getName());
        }
        return result;
    }

    @Command(name="getOutletOnStateMap", description="Get the map of outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        return this.pdu.getOutletOnStateMap();
    }

    @Command(name="outletOn", description="Turn outlet on")
    public void outletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.delayedOutletOn(this.getOutletNumber(name));
    }

    @Command(name="outletOff", description="Turn outlet off")
    public void outletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.delayedOutletOff(this.getOutletNumber(name));
    }

    @Command(name="forceOutletOn", description="Force outlet to turn on")
    public void forceOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.setOutletOn(this.getOutletNumber(name));
    }

    @Command(name="forceOutletOff", description="Force outlet to turn off")
    public void forceOutletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        this.pdu.setOutletOff(this.getOutletNumber(name));
    }

    @Command(name="isOutletOn", description="Get whether outlet is on")
    public boolean isOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        return this.pdu.isOutletOn(this.getOutletNumber(name));
    }

    @Command(name="setOutletState", description="Set the outlet state to a given OutletState")
    public void setOutletState(@Argument(allowedValueProvider="getOutletNames", name="name", description="Outlet name") String name, @Argument(name="state", description="The desired PduOutletState") PduOutletState state, @Argument(name="force", description="true to force the state change", defaultValue="false") boolean force) throws DriverException {
        PduOutlet outlet = this.mapOfOutlets.get(name);
        if (outlet == null) {
            throw new IllegalArgumentException("Outlet name: " + name + " is illegal. The chosen outlet does not exist.");
        }
        if (force) {
            if (state == PduOutletState.OFF) {
                this.pdu.setOutletOff(name);
            } else {
                this.pdu.setOutletOn(name);
            }
        } else if (state == PduOutletState.OFF) {
            this.pdu.delayedOutletOff(name);
        } else {
            this.pdu.delayedOutletOn(name);
        }
        this.stateService.updateAgentComponentState((Object)outlet, new Enum[]{state});
    }

    int getOutletNumber(String name) throws DriverException {
        for (PduOutlet outlet : this.listOfOutlets) {
            if (!outlet.getName().equals(name)) continue;
            return outlet.getIndex();
        }
        throw new DriverException("Invalid outlet name " + name);
    }

    static {
        typeMap.put("POWER", 1);
    }
}

