/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pluto.Pluto;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class PlutoDevice
extends Device {
    private static final int TYPE_GLOBAL = 0;
    private static final int TYPE_ADD_BIT = 1;
    private static final int TYPE_ADD_REG = 2;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    protected String node;
    protected List<Integer> areas;
    private static final Logger LOG;
    private final boolean configAreas;
    private int nArea;
    private Pluto plu;
    private final int[] globData = new int[32];
    private final int[] addData = new int[32];
    private final Set<Integer> modsUsed = new HashSet<Integer>();
    private final Set<Integer> areasUsed = new HashSet<Integer>();

    public PlutoDevice() {
        this.configAreas = true;
    }

    public PlutoDevice(int nArea) {
        this.nArea = nArea;
        this.configAreas = nArea < 0;
    }

    protected void initDevice() {
        super.configure(this.mon);
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"node", (String)"is missing");
        }
        if (this.configAreas) {
            if (this.areas == null) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"areas", (String)"is missing");
            }
            if ((this.areas.size() & 1) != 0) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"areas", (String)"has odd number of elements");
            }
            this.nArea = this.areas.size() / 2;
        }
        this.fullName = "Pluto PLC system (" + this.node + ")";
    }

    protected void initialize() {
        try {
            if (!this.inited || this.plu == null) {
                this.plu = new Pluto();
            }
            this.plu.open(this.node);
            if (this.configAreas) {
                this.plu.configStart(-1, 15, 0, 100);
                for (int j = 0; j < this.areas.size(); j += 2) {
                    this.plu.configDataArea(j / 2, this.areas.get(j).intValue(), this.areas.get(j + 1).intValue());
                }
                this.plu.configWrite();
            }
            this.setOnline(true);
            this.initSensors();
            this.setOutputLines();
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.plu != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        try {
            this.plu.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int id;
        Integer iType = null;
        String[] typeFields = type.split(":", -1);
        if (typeFields.length == 2) {
            iType = typeMap.get(typeFields[0].toUpperCase());
        }
        try {
            id = Integer.decode(typeFields[1]);
        }
        catch (NumberFormatException e) {
            id = -1;
        }
        int maxId = 0;
        if (iType != null) {
            int maxChan;
            int n = maxId = iType == 0 ? 32 : this.nArea;
            int n2 = iType == 0 ? 32 : (maxChan = iType == 1 ? 16 : 2);
            if (hwChan < 0 || hwChan >= maxChan) {
                MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hwchan", (Object)hwChan);
            }
        }
        if (iType == null || id < 0 || id >= maxId) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        Set<Integer> used = iType == 0 ? this.modsUsed : this.areasUsed;
        used.add(id);
        return new int[]{iType << 8 | id, 0};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            for (int id : this.modsUsed) {
                this.globData[id] = this.plu.readGlobalData(id);
            }
            for (int id : this.areasUsed) {
                this.addData[id] = this.plu.readAdditionalData(id);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            int index = type & 0xFF;
            switch (type >> 8) {
                case 0: {
                    value = this.globData[index] >> hwChan & 1;
                    break;
                }
                case 1: {
                    value = this.addData[index] >> hwChan & 1;
                    break;
                }
                case 2: {
                    value = this.addData[index] << 16 * (1 - hwChan) >> 16;
                }
            }
        }
        return value;
    }

    protected void checkHwLine(String name, int line) throws Exception {
        if (line < 0 || line >= 64) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"line", (Object)line);
        }
        this.addLine(line);
    }

    protected void setHwLine(int line, boolean on) {
        this.writeBit(line / 16, line & 0xF, on ? 1 : 0);
    }

    protected Boolean isHwLineSet(int line) {
        return this.readBit(line / 16, line & 0xF) != 0;
    }

    public boolean isPLCActive() {
        try {
            return this.plu.readModuleStatus() != 0;
        }
        catch (DriverException e) {
            return false;
        }
    }

    public void toggleBit(int area, int bit) {
        this.writeBit(area, bit, 1);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.writeBit(area, bit, 0);
    }

    public void writeBit(int area, int bit, int value) {
        try {
            this.plu.writeAreaBit(area, bit, value);
        }
        catch (DriverException e) {
            LOG.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    public Integer readBit(int area, int bit) {
        try {
            return this.plu.readAreaBit(area, bit);
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return null;
        }
    }

    public Integer readAddBit(int area, int bit) {
        if (!this.online) {
            return null;
        }
        try {
            return this.plu.readAdditionalData(area) >> bit & 1;
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return null;
        }
    }

    public void writeRegister(int area, int reg, int value) {
        try {
            this.plu.writeAreaRegister(area, reg, value);
        }
        catch (DriverException e) {
            LOG.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    static {
        typeMap.put("GLOBAL", 0);
        typeMap.put("ADDBIT", 1);
        typeMap.put("ADDREG", 2);
        LOG = Logger.getLogger((String)PlutoDevice.class.getName());
    }
}

