/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.refrigeration;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.ametek.AvcCooler;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.common.devices.refrigeration.data.RefrigerationConfig;
import org.lsst.ccs.subsystem.common.devices.refrigeration.states.CryoDevState;
import org.lsst.ccs.utilities.logging.Logger;

public class AVCCryoDevice
extends Device {
    String serialdev;
    DriverConstants.ConnType connType;
    RefrigerationConfig.CryoTelType devType = null;
    String ident;
    double T_OFFSET = 273.0;
    int baud = 9600;
    int dataChar = 0;
    private final AvcCooler AVCDRV = new AvcCooler();
    RefrigerationConfig cfg = new RefrigerationConfig();
    CryoDevState.cryostates cooler_state = CryoDevState.cryostates.NOTCONFIGURED;
    long last_disconnect = 0L;
    @ConfigurationParameter(category="Limits")
    private double temp_Min_OFF = -140.0;
    @ConfigurationParameter(category="Limits")
    private double temp_Min_ON = -120.0;
    private boolean auto_shutoff_state = false;

    public void initDevice() {
        if (this.serialdev == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.name, (String)"serialdev", (String)"not specified");
        }
        this.fullName = "AVCDRV CryoTel device";
    }

    protected void initialize() {
        block2: {
            try {
                this.AVCDRV.openSerial(this.serialdev, this.baud);
                this.setOnline(true);
                this.initSensors();
                this.cooler_state = CryoDevState.cryostates.OK;
                this.log.info((Object)("Connected to " + this.fullName + " at " + this.serialdev + " and name " + this.name));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                this.log.error((Object)("Error connecting to " + this.fullName + " at " + this.serialdev + " and name " + this.name + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.AVCDRV.close();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan > 2) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        double value = super.readChannel(chan, type);
        if (chan == 0) {
            try {
                value = this.getTemperature();
            }
            catch (Exception e) {
                this.log.error((Object)("Error reading Temperature: " + e));
            }
        }
        if (chan == 1) {
            try {
                value = this.getSetPoint();
            }
            catch (Exception e) {
                this.log.error((Object)("Error reading Temperature: " + e));
            }
        }
        if (chan == 2) {
            try {
                value = this.getPower();
            }
            catch (Exception e) {
                this.log.error((Object)("Error reading Power: " + e));
            }
        }
        return value;
    }

    @Command(description="Reconnect to the cooler")
    public void reconnect() {
        this.setOnline(false);
    }

    @Command(description="Show the product type")
    public String getProduct() throws DriverException {
        return this.AVCDRV.getProductType();
    }

    @Command(description="Show the firmware version")
    public String getVersion() throws DriverException {
        return this.AVCDRV.getFWVersion();
    }

    @Command(description="Show the cooler mode")
    public String getMode() throws DriverException {
        return this.AVCDRV.getMode().toString();
    }

    @Command(description="Set the cooler mode")
    public void setMode(String mode) throws DriverException {
        this.AVCDRV.setMode(AvcCooler.Mode.valueOf((String)mode));
        this.auto_shutoff_state = false;
    }

    @Command(description="Show the target temperature")
    public double getSetPoint() throws DriverException {
        return this.AVCDRV.getTemperature() - this.T_OFFSET;
    }

    @Command(description="Set the target temperature")
    public void setSetPoint(double temp) throws DriverException {
        this.AVCDRV.setTemperature(temp + this.T_OFFSET);
    }

    @Command(description="Get the cooler power")
    public double getPower() throws DriverException {
        return this.AVCDRV.getPower();
    }

    @Command(description="Set the cooler power")
    public void setPower(double pwr) throws DriverException {
        this.AVCDRV.setPower(pwr);
    }

    @Command(description="Show the temperature")
    public double getTemperature() throws DriverException {
        double temp = this.AVCDRV.readTemperature() - this.T_OFFSET;
        if (temp < this.temp_Min_OFF) {
            this.setMode("OFF");
            this.auto_shutoff_state = true;
        }
        if (temp > this.temp_Min_ON && this.auto_shutoff_state) {
            this.setMode("ON");
        }
        return temp;
    }

    @Command(description="Set cryo device status")
    public void setState(@Argument(description="State to set") int istate) {
        this.cooler_state = CryoDevState.cryostates.values()[istate];
    }

    @Command(description="Show the state of the auto shutoff")
    public boolean showAuto_shutoff_state() {
        return this.auto_shutoff_state;
    }

    @Command(description="Set cryo device status")
    public int getState() {
        return this.cooler_state.ordinal();
    }

    private static StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    @Command(description="Get serial dev specification")
    public String getSerialdev() {
        return this.serialdev;
    }

    @Command(description="Get device identifier")
    public String getIdent() {
        return this.ident;
    }

    @Command(description="Get cryotel state")
    public CryoDevState.cryostates getCooler_state() {
        return this.cooler_state;
    }

    @Command(description="Get temperature at which cryotel will be shutoff automatically.")
    public double getTemp_Min_OFF() {
        return this.temp_Min_OFF;
    }

    @Command(description="Set temperature at which cryotel will be shutoff automatically.")
    public void setTemp_Min_OFF(double temp_Min_OFF) {
        this.temp_Min_OFF = temp_Min_OFF;
    }

    @Command(description="Get temperature at which cryotel will be turned on automatically after an automatic shutoff.")
    public double getTemp_Min_ON() {
        return this.temp_Min_ON;
    }

    @Command(description="Set temperature at which cryotel will be turned on automatically after an automatic shutoff.")
    public void setTemp_Min_ON(double temp_Min_ON) {
        this.temp_Min_ON = temp_Min_ON;
    }
}

