/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.xed;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class XED
extends Ascii {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\r\n";
    private int timeout = 5000;
    private boolean isconnected = false;

    public void open(String serialname, int baud) throws DriverException {
        this.init();
        System.out.println("opening connection to the XED");
        try {
            this.open(2, serialname, baud);
            this.setTimeout(this.timeout);
            this.reset();
            String response = null;
            for (int i = 0; i < 7; ++i) {
                response = this.readXED();
                System.out.println(i + " : " + response);
            }
            if (this.getIdent().contains(":")) {
                this.isconnected = true;
            } else {
                System.out.println("XED: connected to port but handshake failed!");
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to open connection to XED device!");
            this.isconnected = false;
        }
    }

    public void openftdi(String serialname, int baud) {
        this.init();
        System.out.println("opening connection to the XED");
        try {
            this.open(1, serialname, baud);
            this.setTimeout(this.timeout);
            this.reset();
            String response = null;
            for (int i = 0; i < 7; ++i) {
                response = this.readXED();
                System.out.println(i + " : " + response);
            }
            if (response.contains(":")) {
                this.isconnected = true;
                System.out.println("Successful connection to XED");
            } else {
                System.out.println("XED: connected to port but handshake failed!");
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to open connection to XED device!");
            this.isconnected = false;
        }
    }

    public void init() {
        this.setTerminator(this.terminator);
    }

    public void close() throws DriverException {
        this.close();
    }

    public void reset() throws DriverException {
        this.writeXED("h");
    }

    public String getIdent() throws DriverException {
        return this.readXED(" ");
    }

    public void extendFe55() throws DriverException {
        if (this.isconnected) {
            this.writeXED("e");
        }
    }

    public void retractFe55() throws DriverException {
        if (this.isconnected) {
            this.writeXED("r");
        }
    }

    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    public synchronized void writeXED(String command) throws DriverException {
        this.write(command + this.terminator);
    }

    public synchronized String readXED() throws DriverException {
        return this.read();
    }

    public synchronized String readXED(String command) throws DriverException {
        this.writeXED(command);
        return this.readXED();
    }
}

